/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.reportservice;

import com.cognos.p2pd.util.PropertyInserter;
import com.cognos.pogo.bibus.RequestAffinity;
import com.cognos.pogo.http.ConnectionCreator;
import com.cognos.pogo.http.ServerConnection;
import com.cognos.pogo.http.StandaloneServerConnection;
import com.cognos.pogo.http.httpclient.MsgBodyGenerator;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.cognos.pogo.pdk.performance.PerformanceIndicator;
import com.cognos.pogo.reportservice.ProcessList;
import com.cognos.pogo.reportservice.ProcessManager;
import com.cognos.pogo.reportservice.RSComponentFactory;
import com.cognos.pogo.reportservice.ReportServerConnection;
import com.cognos.pogo.reportservice.ReportServerConnectionPool;
import com.cognos.pogo.reportservice.ReportServerProcess;
import com.cognos.pogo.reportservice.ReportServerQueueCallback;
import com.cognos.pogo.reportservice.util.PingCommand;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class ProcessFacade
implements Comparable<ProcessFacade> {
    private static int ExternalProcessID = -2;
    private static final Logger category = Hierarchy.getDefaultHierarchy().getLoggerFor(ProcessFacade.class.getName());
    private static int NOOP_TIMEOUT = 60000;
    private RSComponentFactory componentfactory;
    private ReportServerConnectionPool nonAffinePool;
    private ReportServerConnectionPool affinePool;
    private ReportServerConnectionPool cancelPool;
    private ReportServerConnectionPool getPool;
    private ReportServerProcess aReportServerProcess;
    private int maxNonAffineConnections;
    private int maxAffineConnections;
    private int maxGetConnections;
    private Element cclConfiguration;
    private Element warpConfiguration;
    private String reportServerHost;
    private int reportServerPort = -1;
    private boolean useSSL;
    protected String processName;
    protected int processID;
    private ReportServerQueueCallback reportServerQueueCallback;
    private long expiryTime = 0L;
    private int markedAsIdle = 0;
    private int requestCount = 0;
    private int requestCountLimit = -1;
    protected ProcessManager manager;
    private boolean isForcedIdle = false;
    protected static boolean ignoreAffinity = Boolean.parseBoolean(System.getenv("KUBERNETES_MODE"));
    private static final String strWarmupRequest = "<SOAP-ENV:Envelope xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:bus=\"http://developer.cognos.com/schemas/bibus/3/\" xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"> <SOAP-ENV:Header>  <bus:biBusHeader xsi:type=\"bus:biBusHeader\">   <CAM xsi:type=\"bus:CAM\">    <CAMPassport xsi:type=\"bus:CAMPassport\">     <id xsi:type=\"xsd:string\" xml:space=\"preserve\">01:4</id>    </CAMPassport>   </CAM>   <tracking xsi:type=\"bus:tracking\">    <bus:conversationContext xsi:type=\"bus:conversationContext\">     <id xsi:type=\"xsd:string\">lq</id>    </bus:conversationContext>   </tracking>  </bus:biBusHeader> </SOAP-ENV:Header> <SOAP-ENV:Body>  <ns1:private xmlns:ns1=\"http://developer.cognos.com/schemas/reportService/1\">   <command xsi:type=\"xsd:string\">rsvpWarmup</command>  </ns1:private> </SOAP-ENV:Body></SOAP-ENV:Envelope>";

    public ProcessFacade(RSComponentFactory componentfactory, String[] args, Element config, String host, int port, boolean ssl, int pid, ReportServerQueueCallback callback, int maxAffineConnectionCount, int maxNonAffineConnectionCount, Element cclconfig, ProcessManager theManager) throws Exception {
        this(componentfactory, args, config, host, port, ssl, pid, callback, maxAffineConnectionCount, maxNonAffineConnectionCount, 0, cclconfig, theManager);
    }

    public ProcessFacade(RSComponentFactory componentfactory, String[] args, Element config, String host, int port, boolean ssl, int pid, ReportServerQueueCallback callback, int maxAffineConnectionCount, int maxNonAffineConnectionCount, int maxGetConnectionCount, Element cclconfig, ProcessManager theManager) throws Exception {
        this.componentfactory = componentfactory;
        this.processID = pid;
        this.useSSL = ssl;
        this.reportServerQueueCallback = callback;
        this.cclConfiguration = cclconfig;
        this.warpConfiguration = config;
        this.manager = theManager;
        this.maxNonAffineConnections = maxNonAffineConnectionCount;
        this.maxAffineConnections = maxAffineConnectionCount;
        this.maxGetConnections = maxGetConnectionCount;
        this.reportServerHost = host;
        this.reportServerPort = port;
        this.createServerProcess(args, theManager);
        if (ProcessFacade.shouldConfigureProcess()) {
            boolean bProcessConfigured = false;
            if (!this.startedExternally()) {
                this.configureProcess();
                bProcessConfigured = true;
            }
            if (theManager != null && theManager.needsWarmup()) {
                if (!bProcessConfigured) {
                    this.configureProcess();
                }
                this.warmUp();
                if (category.isDebugEnabled()) {
                    category.debug(this.toString() + " A warmup request was sent to " + theManager.getProcessName() + " with pid: " + this.processID);
                }
            }
        }
        this.nonAffinePool = this.createNonAffinePool();
        this.affinePool = this.createAffinePool();
        this.cancelPool = this.createCancelPool();
        this.getPool = this.createGetPool();
    }

    private static boolean shouldConfigureProcess() {
        return !ignoreAffinity;
    }

    protected ReportServerConnectionPool createNonAffinePool() {
        ReportServerConnectionPool pool = this.componentfactory.newReportServerConnectionPool(this.reportServerHost, this.reportServerPort, this.useSSL, this.maxNonAffineConnections, false);
        this.setupConnectionPool(pool, false);
        return pool;
    }

    protected void resizeNonAffinePool(int maxConnections) {
        if (this.getNonAffinePoolSize() != maxConnections) {
            if (category.isDebugEnabled()) {
                category.debug(this.toString() + " NonAffine Pool being resized to: " + maxConnections);
            }
            this.nonAffinePool.resizeConnectionPool(maxConnections);
        }
    }

    protected ReportServerConnectionPool createAffinePool() {
        ReportServerConnectionPool pool = this.componentfactory.newReportServerConnectionPool(this.reportServerHost, this.reportServerPort, this.useSSL, this.maxAffineConnections, true);
        this.setupConnectionPool(pool, true);
        return pool;
    }

    protected void resizeAffinePool(int maxConnections) {
        if (this.affinePool.getCurrentSize() != maxConnections) {
            if (category.isDebugEnabled()) {
                category.debug(this.toString() + " Affine Pool being resized to: " + maxConnections);
            }
            this.affinePool.resizeConnectionPool(maxConnections);
        }
    }

    protected ReportServerConnectionPool createCancelPool() {
        ReportServerConnectionPool pool = this.componentfactory.newReportServerConnectionPool(this.reportServerHost, this.reportServerPort, this.useSSL, this.maxNonAffineConnections + this.maxAffineConnections, true);
        this.setupConnectionPool(pool, true);
        return pool;
    }

    protected ReportServerConnectionPool createGetPool() {
        ReportServerConnectionPool pool = this.componentfactory.newReportServerConnectionPool(this.reportServerHost, this.reportServerPort, this.useSSL, this.maxGetConnections, true);
        this.setupConnectionPool(pool, true, true);
        return pool;
    }

    protected void resizeCancelPool(int maxConnections) {
        if (this.cancelPool.getCurrentSize() != maxConnections) {
            if (category.isDebugEnabled()) {
                category.debug(this.toString() + " Cancel Pool being resized to: " + maxConnections);
            }
            this.cancelPool.resizeConnectionPool(maxConnections);
        }
    }

    protected RSComponentFactory getComponentfactory() {
        return this.componentfactory;
    }

    protected ReportServerConnectionPool getAffinePool() {
        return this.affinePool;
    }

    protected ReportServerConnectionPool getNoneAffinePool() {
        return this.nonAffinePool;
    }

    protected ReportServerConnectionPool getGetPool() {
        return this.getPool;
    }

    public String getReportServerHost() {
        return this.reportServerHost;
    }

    public int getReportServerPort() {
        return this.reportServerPort;
    }

    protected boolean getIsSSL() {
        return this.useSSL;
    }

    protected int getMaxNonAffineConnections() {
        return this.maxNonAffineConnections;
    }

    protected int getMaxAffineConnections() {
        return this.maxAffineConnections;
    }

    protected int getMaxGetConnections() {
        return this.maxGetConnections;
    }

    protected void createServerProcess(String[] args, ProcessManager theManager) throws Exception {
        if (this.reportServerPort == 0) {
            this.createProcess(args, theManager);
            this.aReportServerProcess.start();
            this.reportServerPort = this.aReportServerProcess.getReportServerPort();
            this.processID = this.aReportServerProcess.getProcessID();
            this.processName = this.aReportServerProcess.getProcessName();
            if (category.isInfoEnabled()) {
                category.info(this.toString() + " started");
            }
        } else {
            this.processName = ReportServerProcess.unknownProcessName;
            this.processID = ExternalProcessID;
            category.info(this.toString() + " using remote starter at " + this.reportServerHost + ":" + Integer.toString(this.reportServerPort));
        }
    }

    protected void createProcess(String[] args, ProcessManager theManager) {
        this.aReportServerProcess = this.componentfactory.newReportServerProcess(args, theManager.getWorkingDirectory(), theManager.getRuntimeEnvironment());
    }

    protected void setServerProcess(ReportServerProcess process) {
        this.aReportServerProcess = process;
    }

    protected ReportServerProcess getServerProcess() {
        return this.aReportServerProcess;
    }

    protected void setServerPort(int port) {
        this.reportServerPort = port;
    }

    public void setupConnectionPool(ReportServerConnectionPool aPool, boolean affineOnly) {
        this.setupConnectionPool(aPool, affineOnly, false);
    }

    public void setupConnectionPool(ReportServerConnectionPool aPool, boolean affineOnly, boolean getMethod) {
        aPool.setNonBlocking(true);
        aPool.setReportServerProcessID(this.processID);
        aPool.setDisposeUponFailure(true);
        aPool.setProcessFacade(this);
        aPool.setConnectionFactory(this.createConnectionCreator(affineOnly, getMethod));
    }

    private ConnectionCreator createConnectionCreator(boolean affineOnly, boolean getMethod) {
        return getMethod ? this.componentfactory.newReportServerGETConnectionCreator(affineOnly, this.processID, this) : this.componentfactory.newReportServerConnectionCreator(affineOnly, this.processID, this);
    }

    void reconfigureProcess() throws IOException {
        if (ProcessFacade.shouldConfigureProcess()) {
            this.configureProcess();
        }
    }

    protected void configureProcess() throws IOException {
        BIBusEnvelope envelope = new BIBusEnvelope();
        this.addWarpConfiguration(envelope);
        this.sendXML(envelope.getEnvelope(), "/config", this.reportServerPort, -1);
        if (category.isDebugEnabled()) {
            category.debug("Process " + this.processID + " configured with following base config: " + envelope.getEnvelope().asXML());
        }
        if (this.cclConfiguration != null) {
            if (category.isDebugEnabled()) {
                category.debug("Process " + this.processID + " configured with cclConfiguration: " + this.cclConfiguration.asXML());
            }
            this.sendXML(this.cclConfiguration, "/cclconfiguration", this.reportServerPort, -1);
        } else {
            category.error("Runtime configuration not yet retrieved from Content Manager.  Starting " + this.getProcessName() + " without runtime configuration");
        }
    }

    protected String getWarmupRequest() {
        return strWarmupRequest;
    }

    protected String getWarmupPath() {
        return "/warp";
    }

    protected boolean warmUp() {
        try {
            Document requestDoc = DocumentHelper.parseText((String)this.getWarmupRequest());
            Element eRequest = requestDoc.getRootElement();
            this.sendXMLIgnoreReturnCode(eRequest, this.getWarmupPath(), this.reportServerPort, -1, true);
            return true;
        }
        catch (Exception ex) {
            category.debug("Error while attempting to send " + this.getWarmupPath(), (Throwable)ex);
            return false;
        }
    }

    private void addWarpConfiguration(SOAPEnvelope envelope) {
        if (this.warpConfiguration != null) {
            envelope.getBody().add(this.warpConfiguration.createCopy());
        }
    }

    void sendXML(Element xmlElement, String path, int port, int timeOut) throws IOException {
        int returnCode = this.sendXMLIgnoreReturnCode(xmlElement, path, port, timeOut, false);
        if (returnCode != 200) {
            throw new IOException("Report Server failed to receive a request");
        }
    }

    private int sendXMLIgnoreReturnCode(Element xmlElement, String path, int port, int timeOut, boolean initZipi) throws IOException {
        ServerConnection connection = this.prepareServerConnection(xmlElement, port, timeOut);
        this.initZipi(connection, initZipi);
        int returnCode = connection.sendRequest(path);
        InputStream isResponse = connection.getInputStream();
        if (isResponse != null) {
            byte[] buffer = new byte[8192];
            int iread = -1;
            while ((iread = isResponse.read(buffer)) >= 0) {
            }
        }
        connection.release();
        return returnCode;
    }

    private void initZipi(ServerConnection connection, boolean initZipi) {
        if (initZipi && PerformanceIndicator.getListener().isEnabled()) {
            connection.addRequestHeader("zipi.id", "warmup");
        }
    }

    protected ServerConnection prepareServerConnection(Element xmlElement, int port, int timeOut) {
        ServerConnection connection = this.createServerConnection(port);
        if (this.getLightThreads() > 0) {
            byte[] prologue = new byte[]{1};
            connection.setConnectionPrologue(prologue);
        }
        connection.setRequestBodySource(new MyMsgSource(xmlElement));
        connection.setSocketTimeout(timeOut > 0 ? timeOut : 60000);
        return connection;
    }

    protected ServerConnection createServerConnection(int port) {
        return new StandaloneServerConnection(this.reportServerHost, port, this.useSSL);
    }

    protected ReportServerConnection getAffineConnection(RequestAffinity requestAffinity) throws IllegalStateException {
        ReportServerConnection aConnection = (ReportServerConnection)this.affinePool.getConnection();
        if (aConnection == null) {
            category.debug("All connections are in use in the affine pool.  Trying non-affine pool");
            return this.getNonAffineConnection();
        }
        this.setMarkedAsIdle(false);
        aConnection.setNonAffine(false);
        return aConnection;
    }

    ReportServerConnection getCancelConnection() throws IllegalStateException {
        ReportServerConnection aConnection = (ReportServerConnection)this.cancelPool.getConnection();
        if (aConnection == null) {
            return null;
        }
        this.setMarkedAsIdle(false);
        aConnection.setNonAffine(false);
        aConnection.setCancelOnly(true);
        return aConnection;
    }

    ReportServerConnection getGetConnection() throws IllegalStateException {
        ReportServerConnection aConnection = (ReportServerConnection)this.getPool.getConnection();
        if (aConnection == null) {
            return null;
        }
        this.setMarkedAsIdle(false);
        aConnection.setNonAffine(false);
        return aConnection;
    }

    protected ReportServerConnection getNonAffineConnection() throws IllegalStateException {
        if (this.isExpired()) {
            category.debug("Cannot get a connection from an expired process");
            return null;
        }
        ReportServerConnection aConnection = (ReportServerConnection)this.nonAffinePool.getConnection();
        if (aConnection == null) {
            category.debug("All connections are in use in the non-affine pool");
            return null;
        }
        this.setMarkedAsIdle(false);
        this.incrementAndCheckRequestCount();
        aConnection.setNonAffine(true);
        return aConnection;
    }

    public String getProcessName() {
        return this.processName;
    }

    int getProcessID() {
        return this.processID;
    }

    boolean startedExternally() {
        return this.processID == ExternalProcessID;
    }

    public void assignConnections() {
        if (this.isCallbackQueueEmpty()) {
            return;
        }
        for (int i = this.maxNonAffineConnections; i > 0; --i) {
            ReportServerConnection aConnection = this.getNonAffineConnection();
            RequestAffinity affinity = this.reportServerQueueCallback.wakeNextRequest(aConnection, this.getProcessID());
            if (aConnection == null || affinity != null) continue;
            aConnection.release();
            return;
        }
    }

    private boolean isCallbackQueueEmpty() {
        return this.reportServerQueueCallback == null || this.reportServerQueueCallback.getQueueSize() == 0;
    }

    protected void sendStop() {
        if (category.isInfoEnabled()) {
            category.info("Shutting down " + this.toString());
        }
        if (this.startedExternally()) {
            category.debug("process was manually started, so we don't send stop.");
            return;
        }
        try {
            BIBusEnvelope envelope = new BIBusEnvelope();
            category.info("sending /stop");
            this.sendXML(envelope.getEnvelope(), "/stop", this.reportServerPort, -1);
            category.info("/stop sent");
            ReportServerProcess.logReportServerStatus(this.getClass().getName(), false, "BIBus.sendStopRequst", new Object[]{this.getProcessName(), String.valueOf(this.getProcessID())});
        }
        catch (Exception ex) {
            category.info("Error while attempting to sending /stop", (Throwable)ex);
        }
        this.disposePools();
    }

    protected void disposePools() {
        this.nonAffinePool.dispose();
        this.affinePool.dispose();
        this.cancelPool.dispose();
        this.getPool.dispose();
    }

    void checkPoolsForIdleConnetions() {
        if (this.nonAffinePool != null) {
            this.nonAffinePool.terminateIdle();
        }
        if (this.affinePool != null) {
            this.affinePool.terminateIdle();
        }
        if (this.cancelPool != null) {
            this.cancelPool.terminateIdle();
        }
        if (this.getPool != null) {
            this.getPool.terminateIdle();
        }
    }

    void kill() {
        if (this.aReportServerProcess != null) {
            if (category.isInfoEnabled()) {
                category.info(this.toString() + " forcibly killed");
            }
            this.aReportServerProcess.stop();
        }
    }

    int exitValue() throws IllegalThreadStateException {
        if (this.aReportServerProcess == null) {
            return -1;
        }
        return this.aReportServerProcess.exitValue();
    }

    public boolean isIdle() {
        if (category.isDebugEnabled()) {
            category.debug("testing isIdle, process " + this.getProcessID());
        }
        if (this.isForcedIdle) {
            category.debug("isIdle: forced idle.");
            return true;
        }
        if (!this.nonAffinePool.isIdle()) {
            category.debug("isIdle: nonAffinePool is not idle.");
            return false;
        }
        if (!this.affinePool.isIdle()) {
            category.debug("isIdle: affinePool is not idle.");
            return false;
        }
        if (!this.cancelPool.isIdle()) {
            category.debug("isIdle: cancelPool is not idle.");
            return false;
        }
        if (!this.getPool.isIdle()) {
            category.debug("isIdle: getPool is not idle.");
            return false;
        }
        category.debug("isIdle returns true");
        return true;
    }

    void setCclConfiguration(Element config) {
        this.cclConfiguration = config;
    }

    public boolean isExpired() {
        return this.getExpiryTime() > 0L;
    }

    protected synchronized void setExpired(boolean expired) {
        if (this.isExpired() == expired) {
            return;
        }
        long l = this.expiryTime = expired ? System.currentTimeMillis() : 0L;
        if (category.isDebugEnabled()) {
            category.debug(this.toString() + (this.isExpired() ? " has expired" : " is no longer expired"));
        }
    }

    public synchronized long getExpiryTime() {
        return this.expiryTime;
    }

    public String toString() {
        return "Process " + this.getProcessName() + "(PID: " + this.getProcessID() + ")";
    }

    public int isMarkedAsIdle() {
        return this.markedAsIdle;
    }

    public int setMarkedAsIdle(boolean markedAsIdle) {
        this.markedAsIdle = markedAsIdle ? ++this.markedAsIdle : 0;
        return this.markedAsIdle;
    }

    @Override
    public int compareTo(ProcessFacade otherObject) {
        int otherObjectCurrentSize;
        if (this.isExpired() && otherObject.isExpired()) {
            return 0;
        }
        if (this.isExpired()) {
            return 1;
        }
        if (otherObject.isExpired()) {
            return -1;
        }
        int currentSize = this.getNonAffinePoolSize();
        if (currentSize < (otherObjectCurrentSize = otherObject.getNonAffinePoolSize())) {
            return -1;
        }
        if (currentSize == otherObjectCurrentSize) {
            return 0;
        }
        return 1;
    }

    protected int getNonAffinePoolSize() {
        return this.nonAffinePool.getCurrentSize();
    }

    boolean pastWatermark() {
        int currentUsage = this.getNonAffinePoolSize();
        return currentUsage * 2 >= this.maxNonAffineConnections;
    }

    public void setRequestCountLimit(int limit) {
        this.requestCountLimit = limit;
    }

    protected synchronized void incrementAndCheckRequestCount() {
        if (this.requestCountLimit < 1 || this.isExpired()) {
            return;
        }
        if (++this.requestCount >= this.requestCountLimit) {
            if (category.isInfoEnabled()) {
                category.info(this.toString() + " being expired because it has reached its usage count");
            }
            this.setExpired(true);
        } else if (category.isDebugEnabled()) {
            category.debug(this.toString() + " not being expired because the usage count is at: " + this.requestCount);
        }
    }

    boolean handoffConnection(ReportServerConnection aConnection) {
        if (this.isExpired()) {
            return false;
        }
        RequestAffinity requestAffinity = this.reportServerQueueCallback.wakeNextRequest(aConnection, this.processID);
        if (requestAffinity != null) {
            if (requestAffinity != RequestAffinity.ABSOLUTE && requestAffinity != RequestAffinity.GET && requestAffinity != RequestAffinity.HIGH) {
                this.incrementAndCheckRequestCount();
            }
            if (this.isExpired()) {
                this.manager.createAnotherProcess();
            }
        }
        return requestAffinity != null;
    }

    int getOutstandingRequestCount() {
        return this.getNonAffinePoolSize() + this.affinePool.getCurrentSize() + this.cancelPool.getCurrentSize() + this.getPool.getCurrentSize();
    }

    public int getRequestCapacity() {
        return this.getNonAffinePoolSize();
    }

    public void setForcedIdle(boolean isForcedIdle) {
        if (this.isForcedIdle == isForcedIdle) {
            return;
        }
        this.isForcedIdle = isForcedIdle;
        if (category.isDebugEnabled()) {
            category.debug(this.toString() + " forced " + (isForcedIdle ? "idle" : "not idle"));
        }
    }

    private int getNoopTimeout() {
        int noopTimeout;
        try {
            noopTimeout = Integer.parseInt(PropertyInserter.getProperty("dispatcher.noop_timeout", "" + NOOP_TIMEOUT));
        }
        catch (NumberFormatException ex) {
            noopTimeout = NOOP_TIMEOUT;
        }
        return noopTimeout;
    }

    void dumpUsage(PrintWriter pw) throws IOException {
        pw.print("Process ");
        pw.print(this.getProcessID());
        if (this.isExpired()) {
            pw.println("(Expiring)");
        } else {
            pw.println();
        }
        pw.println();
        pw.print("Affine pool of size: ");
        pw.println(this.maxAffineConnections);
        this.affinePool.dumpUsage(pw);
        pw.println();
        pw.print("Non Affine pool of size: ");
        pw.println(this.maxNonAffineConnections);
        this.nonAffinePool.dumpUsage(pw);
        pw.println();
        pw.print("Get pool of size: ");
        pw.println(this.maxGetConnections);
        this.getPool.dumpUsage(pw);
        pw.println();
    }

    void terminateDelinquents(ProcessList processList, int timeLimitSeconds) {
        this.affinePool.terminateDelinquents(processList, timeLimitSeconds);
        this.nonAffinePool.terminateDelinquents(processList, timeLimitSeconds);
    }

    public boolean isAlive() {
        return this.sendNoop();
    }

    boolean sendNoop() {
        try {
            BIBusEnvelope envelope = new BIBusEnvelope();
            this.sendXMLIgnoreReturnCode(envelope.getEnvelope(), "/noop", this.reportServerPort, this.getNoopTimeout(), false);
            return true;
        }
        catch (Exception ex) {
            category.debug("Error while attempting to sending /noop", (Throwable)ex);
            return false;
        }
    }

    boolean ping() {
        if (this.startedExternally()) {
            return true;
        }
        PingCommand pingCommand = PingCommand.createPingCommand();
        return pingCommand.pingProcess(this.processID);
    }

    public int getLightThreads() {
        return this.manager == null ? 0 : this.manager.getLightThreads();
    }

    private static class MyMsgSource
    implements MsgBodyGenerator {
        Element xmlElement;

        MyMsgSource(Element xmlElement) {
            this.xmlElement = xmlElement;
        }

        @Override
        public void writeBody(OutputStream outStream) throws IOException {
            XMLWriter xmlWriter = new XMLWriter(outStream, new OutputFormat("\t", true));
            xmlWriter.write(this.xmlElement);
            xmlWriter.flush();
        }

        @Override
        public boolean rewind() {
            return true;
        }
    }
}

