/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.reportservice;

import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.p2pd.util.PropertyInserter;
import com.cognos.pogo.logging.LoggingContext;
import com.cognos.pogo.logging.LoggingRealm;
import com.cognos.pogo.logging.LoggingRealmFactory;
import com.cognos.pogo.monitoring.QueueableRequestReporter;
import com.cognos.pogo.reportservice.ProcessFacade;
import com.cognos.pogo.reportservice.ProcessList;
import com.cognos.pogo.reportservice.ProcessReaper;
import com.cognos.pogo.reportservice.RSComponentFactory;
import com.cognos.pogo.reportservice.ReportServerProcess;
import com.cognos.pogo.reportservice.ReportServerQueueCallback;
import com.cognos.pogo.util.PogoIPFLog;
import com.cognos.pogo.util.PogoLogger;
import com.cognos.pogo.util.RuntimeEnvironment;
import com.cognos.pogo.util.threads.SafeThread;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.dom4j.Element;

public class ProcessManager
extends SafeThread {
    private static final PogoLogger log = PogoLogger.getLogger();
    static final LoggingRealm loggingRealm = LoggingRealmFactory.getInstance("DISP");
    private static final int TIMEOUT_FOR_ACTIVE_CM_PROCESS_CLEANUP = 0;
    private static final int DEFAULT_PROCESS_CLEANER_INTERVAL = 0;
    private static final int UNDEFINED_PROCESS_CLEANER_INTERVAL = -1;
    private static final int SHUTDOWN_TIMEOUT = 500;
    private boolean shutdown;
    private boolean startProcess;
    private boolean isSuspended;
    private ReportServerQueueCallback queueCallback;
    private String[] commandLineArguments;
    private Element processConfiguration;
    private Element cclConfiguration;
    private String processName;
    private String processHost;
    private int processPort;
    private boolean processSsl;
    private int minProcessCount = 1;
    private int maxProcessCount = 2;
    private int maxAffineConnectionsPerProcess = 1;
    private int maxNonAffineConnectionsPerProcess = 4;
    private int childProcThreads = 10;
    private String activeCM = "";
    private QueueableRequestReporter reporter;
    private RuntimeEnvironment runtimeEnvironment;
    private int startCount = 0;
    protected ProcessReaper processReaper;
    private int idleProcessMaxIntervals = 10;
    private long idleProcessCheckIntervalms = 30000L;
    private long idleMaxWaitInSecs = defaultIdleMaxWaitInSecs;
    private long bibusTKServerConnectionAgeLimit_ms = 0L;
    private int requestCountLimit = -1;
    private boolean configurationChanged;
    private Object configurationChangedMutex = new Object();
    protected ProcessList processList;
    private String workingDirectory;
    private Timer delinquentTimer;
    private String localServiceName;
    private int delinquenceLimit = 0;
    private RSComponentFactory compFactory;
    protected int processCleanerInterval = -1;
    private boolean warmup = false;
    private int numWarmedUp = 0;
    private int lightThreads = 0;
    protected static long defaultIdleMaxWaitInSecs;

    public ProcessManager(RSComponentFactory compFactory, String serviceName, ReportServerQueueCallback callback, String[] args, Element config, String host, int port, boolean ssl) {
        this(compFactory, serviceName, callback, args, config, host, port, ssl, new RuntimeEnvironment(config));
    }

    protected ProcessManager(RSComponentFactory compFactory, String serviceName, ReportServerQueueCallback callback, String[] args, Element config, String host, int port, boolean ssl, RuntimeEnvironment runtimeEnvironment) {
        super(serviceName + "-ProcessMgrThread");
        List initParamList;
        this.compFactory = compFactory;
        this.runtimeEnvironment = runtimeEnvironment;
        this.localServiceName = serviceName;
        this.queueCallback = callback;
        this.commandLineArguments = args;
        this.processConfiguration = config.createCopy();
        this.processName = ReportServerProcess.extractProcessName(this.commandLineArguments);
        this.processHost = host;
        this.processPort = port;
        this.processSsl = ssl;
        this.createProcessReaperAndList(serviceName);
        boolean matchedThreads = false;
        for (int i = 0; i < this.commandLineArguments.length; ++i) {
            if (!this.commandLineArguments[i].startsWith("threads=")) continue;
            int threadsIdx = this.commandLineArguments[i].indexOf("=");
            try {
                this.childProcThreads = Integer.parseInt(this.commandLineArguments[i].substring(threadsIdx + 1));
                log.debug("determined value of threads= from command line args: ", this.childProcThreads);
            }
            catch (NumberFormatException e) {
                log.warn("Failed to parse threads= argument in child process arguments.", e);
            }
            matchedThreads = true;
            break;
        }
        if (!matchedThreads) {
            log.warn("Did not find threads= argument in child process arguments.");
        }
        List list = initParamList = this.processConfiguration != null ? this.processConfiguration.elements("init-param") : null;
        if (initParamList != null) {
            for (Element initParamElement : initParamList) {
                if (!initParamElement.elementTextTrim("param-name").equalsIgnoreCase("bibusTKServerConnectionAgeLimit_ms")) continue;
                try {
                    this.bibusTKServerConnectionAgeLimit_ms = Long.parseLong(initParamElement.elementTextTrim("param-value"));
                    log.debug(this.processName, " using a connection age limit(ms) set to ", this.bibusTKServerConnectionAgeLimit_ms);
                }
                catch (NumberFormatException e) {
                    log.error("Failed to parse bibusTKServerConnectionAgeLimit_ms from service file", e);
                }
            }
        }
    }

    protected void createProcessReaperAndList(String serviceName) {
        this.processReaper = this.createProcessReaper(serviceName);
        this.processList = this.createProcessList(serviceName, this.processReaper);
    }

    protected ProcessReaper createProcessReaper(String serviceName) {
        return new ProcessReaper(serviceName + "-ProcessReaper");
    }

    protected ProcessList createProcessList(String serviceName, ProcessReaper processReaper) {
        return new ProcessList(processReaper, this, serviceName);
    }

    public void setIdleProcessTimeout(long checkIntervalms, int maxIdleIntervals, long maxWaitInSecs) {
        this.idleProcessCheckIntervalms = checkIntervalms;
        this.idleProcessMaxIntervals = maxIdleIntervals;
        this.idleMaxWaitInSecs = maxWaitInSecs >= 0L ? maxWaitInSecs : defaultIdleMaxWaitInSecs;
    }

    public void setIdleProcessTimeout(long checkIntervalms, int maxIdleIntervals) {
        this.idleProcessCheckIntervalms = checkIntervalms;
        this.idleProcessMaxIntervals = maxIdleIntervals;
    }

    public String[] getCommandLineArguments() {
        return this.commandLineArguments;
    }

    protected Element getProcessConfiguration() {
        return this.processConfiguration;
    }

    protected String getProcessName() {
        return this.processName;
    }

    public String getProcessHost() {
        return this.processHost;
    }

    public int getProcessPort() {
        return this.processPort;
    }

    protected boolean getProcessSSL() {
        return this.processSsl;
    }

    protected Element getCCLConfiguration() {
        return this.cclConfiguration;
    }

    protected int getMaxAffineConnectionsPerProcess() {
        return this.maxAffineConnectionsPerProcess;
    }

    protected int getMaxNonAffineConnectionsPerProcess() {
        return this.maxNonAffineConnectionsPerProcess;
    }

    public int getIdleProcessMaxIntervals() {
        return this.idleProcessMaxIntervals;
    }

    public long getIdleProcessCheckIntervalms() {
        return this.idleProcessCheckIntervalms;
    }

    public long getIdleMaxWaitInSecs() {
        return this.idleMaxWaitInSecs;
    }

    @Override
    public void start() {
        this.startProcessReaper();
        this.startInitialProcesses();
        super.start();
        this.startIdleProcessChecking();
        if (this.idleProcessCheckIntervalms != 0L) {
            this.startIdleConnectionPoolsChecking();
        }
        if (this.delinquenceLimit > 0) {
            this.delinquentTimer = new Timer(false);
            long period = this.delinquenceLimit * 1000 / 2;
            log.info("Starting request delinquent timer to run every ", period, " ms");
            this.delinquentTimer.schedule((TimerTask)new TerminateDelinquentsTimerTask(this.delinquenceLimit), period, period);
        }
        this.startProcessCleaning();
    }

    protected void startIdleProcessChecking() {
        if (this.idleProcessCheckIntervalms > 0L) {
            this.processList.scheduleIdleProcessChecking(this.idleProcessMaxIntervals, this.idleProcessCheckIntervalms, this.idleMaxWaitInSecs);
        }
    }

    protected void startIdleConnectionPoolsChecking() {
        if (this.bibusTKServerConnectionAgeLimit_ms > 0L) {
            this.processList.scheduleIdlePoolChecking(this.bibusTKServerConnectionAgeLimit_ms);
        }
    }

    void startProcessCleaning() {
        this.processList.startProcessCleaning(this.getProcessCleanerInterval());
    }

    protected void startProcessReaper() {
        this.processReaper.start();
    }

    protected void startThread() {
    }

    @Override
    public void safeRun() {
        this.setupLoggingContext();
        while (!this.shutdown) {
            this.sleepUntilStartHint();
            if (this.shutdown) continue;
            this.startProcessesDueToCapacity();
        }
        log.debug("left run() loop, calling cleanup");
        this.processList.cleanup(500);
    }

    private void setupLoggingContext() {
        LoggingContext lc = loggingRealm.getLoggingContext();
        lc.setSessionID("rsProcessStarter");
        lc.setRequestID("na");
        lc.setStepID("0");
    }

    private void startInitialProcesses() {
        if (this.startCount > 0) {
            log.debug("starting process(es) because startCount is > 0: ", this.startCount);
            while (this.startCount-- > 0) {
                ReportServerProcess.logReportServerStatus(this.getClass().getName(), true, "BIBus.startedDueToStartCount", new Object[]{this.getProcessName(), String.valueOf(this.startCount + 1)});
                this.startProcess();
            }
        }
    }

    private void startProcessesDueToCapacity() {
        while (!this.shutdown && !this.isSuspended) {
            int processCount = this.processList.activeProcessCount();
            if (processCount >= this.maxProcessCount) {
                log.debug("Cannot start more processes, process count=", processCount);
                return;
            }
            log.debug("Starting another process, process count=", processCount);
            ReportServerProcess.logReportServerStatus(this.getClass().getName(), true, "BIBus.startedDueToProcessCount", new Object[]{this.getProcessName(), String.valueOf(processCount), String.valueOf(this.maxProcessCount)});
            this.startProcess();
            int queueSize = this.queueCallback.getNonAffineQueueSize();
            log.debug("Non-affine requests remaining in the queue: ", queueSize);
            if (queueSize != 0) continue;
            log.debug("Non-affine queue is empty, will not start more processes.");
            return;
        }
    }

    private synchronized void sleepUntilStartHint() {
        if (this.isStartProcess()) {
            this.setStartProcess(false);
        } else if (!this.shutdown) {
            try {
                log.debug("about to wait");
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            log.debug("Thread waking up.");
            this.setStartProcess(false);
        }
    }

    private synchronized boolean isStartProcess() {
        return this.startProcess;
    }

    private synchronized void setStartProcess(boolean b) {
        this.startProcess = b;
    }

    public synchronized void shutdown() {
        this.shutdown = true;
        this.processList.setShutdown(true);
        this.notify();
        try {
            this.join(50L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.processReaper.shutdown();
    }

    synchronized boolean isShutdown() {
        return this.shutdown;
    }

    public synchronized void createAnotherProcess() {
        this.startProcess = true;
        this.notify();
    }

    public synchronized void createAnotherProcess(int count) {
        this.startCount = count;
    }

    protected void startProcess() {
        ProcessFacade aProcess;
        int activeProcessCount = this.processList.activeProcessCount();
        if (activeProcessCount >= this.maxProcessCount) {
            log.debug("Will not start another process.  Active number of processes: ", activeProcessCount, ", maximum number of processes: ", this.maxProcessCount);
            return;
        }
        try {
            int defaultInitialProcessID = -1;
            aProcess = this.createProcessFacade(defaultInitialProcessID);
            aProcess.setRequestCountLimit(this.requestCountLimit);
            this.processReaper.registerLiveProcess(aProcess);
            log.debug("Process ", aProcess.getProcessID(), " started");
        }
        catch (Exception ex) {
            PogoIPFLog.getInstance().logFailureStatus("ProcessManager.notStarted", new Object[]{this.getProcessName()});
            log.fatalError("External Report Server process " + this.getProcessName() + " cannot be started", ex);
            return;
        }
        aProcess.assignConnections();
        this.processList.addProcess(aProcess);
        this.reportProcessCount();
        PogoIPFLog.getInstance().logSuccessStatus("ProcessManager.started", new Object[]{this.getProcessName()});
    }

    void reportProcessCount() {
        if (this.reporter != null) {
            this.reporter.reportProcessCount(this.processList.size());
        }
    }

    private ProcessFacade createProcessFacade(int nextProcessID) throws Exception {
        return this.compFactory.newProcessFacade(this.commandLineArguments, this.processConfiguration, this.processHost, this.processPort, this.processSsl, nextProcessID, this.queueCallback, this.maxAffineConnectionsPerProcess, this.maxNonAffineConnectionsPerProcess, this.cclConfiguration, this);
    }

    public void suspend(boolean immediate) {
        this.suspend(immediate, -1);
    }

    public void suspend(boolean immediate, int shutdownImmediateTimeLimit) {
        this.isSuspended = true;
        this.processList.suspend();
        if (immediate) {
            this.processList.cleanup(shutdownImmediateTimeLimit);
            this.reporter.reportProcessCount(0);
        }
    }

    public void resumeIt() {
        this.isSuspended = false;
        this.processList.resume();
    }

    public void setMaxProcessCount(int maxProcess) {
        if (this.processPort != 0) {
            log.debug("Forcing maxProcess to 1 since the Report Server process is started manually");
            maxProcess = 1;
        }
        if (this.maxProcessCount == maxProcess) {
            return;
        }
        int oldValue = this.maxProcessCount;
        if (maxProcess < 1) {
            log.warn("Maximum process is configued to be less than one.  Using 'one'.");
            this.maxProcessCount = 1;
        } else {
            log.debug("Setting the maximum number of Report Server processes to: ", maxProcess);
            this.maxProcessCount = maxProcess;
        }
        if (this.reporter != null) {
            this.reporter.reportConfiguredProcessCount(this.maxProcessCount);
        }
        this.processList.setMaxProcessCount(this.maxProcessCount);
        if (oldValue > this.maxProcessCount) {
            log.debug("Looking for processes to expire to conform to new max process limit");
            this.processList.expireExcessProcesses(this.maxProcessCount);
        }
    }

    public void updateConnectionsPerProcess(int maxAffineConnections, int maxNonAffineConnections) {
        if (this.maxNonAffineConnectionsPerProcess == maxNonAffineConnections && this.maxAffineConnectionsPerProcess == maxAffineConnections) {
            return;
        }
        this.maxNonAffineConnectionsPerProcess = maxNonAffineConnections;
        this.maxAffineConnectionsPerProcess = maxAffineConnections;
        boolean matched = false;
        for (int i = 0; i < this.commandLineArguments.length; ++i) {
            if (!this.commandLineArguments[i].startsWith("threads=")) continue;
            if (this.childProcThreads == -1) {
                log.info("Threads init-param set to -1 in service xml file. Will resize connection pools.");
                this.processList.resizeConnectionPools(maxAffineConnections, maxNonAffineConnections);
            } else {
                log.info("Will restart BIBusTKs with command line parameter threads set to: ", (maxAffineConnections + maxNonAffineConnections) * 2);
                this.commandLineArguments[i] = "threads=" + (maxAffineConnections + maxNonAffineConnections) * 2;
                this.setConfigurationChanged();
            }
            matched = true;
            break;
        }
        if (!matched) {
            log.warn("Did not find threads= argument in child process arguments.");
        }
    }

    public void updateActiveCM(String newActiveCM) {
        if (this.activeCM.equals(newActiveCM)) {
            return;
        }
        this.activeCM = newActiveCM;
        this.processList.cleanup(0);
    }

    public void setMinProcessCount(int minProcesses) {
        this.minProcessCount = minProcesses;
        this.processList.setMinProcessCount(this.minProcessCount);
    }

    public int getMinProcessCount() {
        return this.minProcessCount;
    }

    public void setCclConfiguration(Element config) {
        this.cclConfiguration = config;
    }

    public void setRequestReporter(QueueableRequestReporter aRequestReporter) {
        if (aRequestReporter == null) {
            return;
        }
        this.reporter = aRequestReporter;
        this.processList.setRequestReporter(this.reporter);
        this.reporter.reportConfiguredProcessCount(this.maxProcessCount);
    }

    public void correctProcessBinaryPath(ICCLConfiguration configuration) {
        this.commandLineArguments[0] = configuration.resolveEffectivePath(this.commandLineArguments[0]);
        for (int i = 0; i < this.commandLineArguments.length; ++i) {
            if (!this.commandLineArguments[i].startsWith("COG_ROOT=")) continue;
            this.commandLineArguments[i] = "COG_ROOT=" + configuration.resolveEffectivePath("..");
            break;
        }
    }

    public int getMaxProcessCount() {
        return this.maxProcessCount;
    }

    public void setRequestCountLimit(int newRequestCountLimit) {
        if (newRequestCountLimit != this.requestCountLimit) {
            this.requestCountLimit = newRequestCountLimit;
            this.setConfigurationChanged();
        }
    }

    public int getRequestCountLimit() {
        return this.requestCountLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void useNewConfiguration() {
        Object object = this.configurationChangedMutex;
        synchronized (object) {
            if (this.configurationChanged) {
                this.configurationChanged = false;
                this.processList.expireAllProcesses();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConfigurationChanged() {
        Object object = this.configurationChangedMutex;
        synchronized (object) {
            this.configurationChanged = true;
        }
    }

    public void reconfigureProcess(int processID) {
        this.processList.reconfigureProcess(processID);
    }

    public ProcessList getProcessList() {
        return this.processList;
    }

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void setWorkingDirectory(String workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public int getRequestUsage() {
        return this.processList.getRequestCount();
    }

    public int getShutdownTimeLimit() {
        return this.processReaper.getShutdownTimeLimit();
    }

    protected ReportServerQueueCallback getQueueCallback() {
        return this.queueCallback;
    }

    public void setShutdownTimeLimit(int shutdownTimeLimit) {
        this.processReaper.setShutdownTimeLimit(shutdownTimeLimit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dumpUsage(PrintWriter pw) throws IOException {
        int queueSize = 0;
        int nonAffineQueueSize = 0;
        ReportServerQueueCallback reportServerQueueCallback = this.queueCallback;
        synchronized (reportServerQueueCallback) {
            queueSize = this.queueCallback.getQueueSize();
            nonAffineQueueSize = this.queueCallback.getNonAffineQueueSize();
        }
        pw.println();
        pw.println("Writing Report Server connection usage information");
        pw.print("There are currently ");
        pw.print(queueSize);
        pw.print(" requests in the queue. ");
        pw.print(nonAffineQueueSize);
        pw.println(" of which are non-affine.");
        pw.println();
        for (ProcessFacade facade : this.processList.getProcesListView()) {
            facade.dumpUsage(pw);
        }
    }

    public int getDelinquenceLimit() {
        return this.delinquenceLimit;
    }

    public void setDelinquenceLimit(int delinquenceLimit) {
        this.delinquenceLimit = delinquenceLimit;
    }

    public int getQueueSize() {
        return this.queueCallback == null ? 0 : this.queueCallback.getQueueSize();
    }

    public long getConnectionAgeLimitInMillis() {
        return this.bibusTKServerConnectionAgeLimit_ms;
    }

    public void setProcessCleanerInterval(int processCleanerInterval) {
        this.processCleanerInterval = processCleanerInterval;
    }

    public int getProcessCleanerInterval() {
        if (this.processCleanerInterval == -1) {
            this.processCleanerInterval = this.getProcessCleanerIntervalFromProperties();
        }
        return this.processCleanerInterval;
    }

    private int getProcessCleanerIntervalFromProperties() {
        String property = PropertyInserter.getProperty("processCheckInterval");
        if (property != null) {
            try {
                return Integer.parseInt(property);
            }
            catch (NumberFormatException e) {
                log.debug("ProcessCheckInterval property (", property, "is mal-formed, default is used.");
            }
        }
        return 0;
    }

    public RuntimeEnvironment getRuntimeEnvironment() {
        return this.runtimeEnvironment;
    }

    public void setEnvironmentReplacement(String environmentReplacement) {
        this.getRuntimeEnvironment().setEnvironmentReplacement(environmentReplacement);
    }

    public String getEnvironmentReplacementForTesting() {
        return this.getRuntimeEnvironment().getEnvironmentReplacementForTesting();
    }

    public void setWarmup(boolean warmup) {
        this.warmup = warmup;
    }

    public boolean getWarmup() {
        return this.warmup;
    }

    public boolean needsWarmup() {
        boolean doWarmup = false;
        if (this.getWarmup()) {
            doWarmup = this.numWarmedUp++ < this.getMinProcessCount();
        }
        return doWarmup;
    }

    public void setLightThreads(int lightThreads) {
        this.lightThreads = lightThreads;
    }

    public int getLightThreads() {
        return this.lightThreads;
    }

    static {
        String propertyName = "dispatcher.DefaultMaxWaitForExpiredProcessToBecomeIdleInSecs";
        long oneDayInSecs = 86400L;
        String idleMaxWaitValue = PropertyInserter.getProperty(propertyName, String.valueOf(oneDayInSecs));
        try {
            defaultIdleMaxWaitInSecs = Integer.parseInt(idleMaxWaitValue);
        }
        catch (NumberFormatException ex) {
            defaultIdleMaxWaitInSecs = oneDayInSecs;
            log.warn("Invalid property value [", propertyName, "] = [", idleMaxWaitValue, "]. Using default value: ", defaultIdleMaxWaitInSecs);
        }
        log.debug("Using ", propertyName, ": ", defaultIdleMaxWaitInSecs);
    }

    class TerminateDelinquentsTimerTask
    extends TimerTask {
        String threadName;
        int timeLimit;

        TerminateDelinquentsTimerTask(int timeLimitSeconds) {
            this.timeLimit = timeLimitSeconds;
            this.threadName = ProcessManager.this.localServiceName + "-TerminateDelinquentsTimerThread";
        }

        @Override
        public void run() {
            try {
                if (ProcessManager.this.delinquenceLimit <= 0) {
                    return;
                }
                Thread.currentThread().setName(this.threadName);
                for (ProcessFacade facade : ProcessManager.this.processList.getProcesListView()) {
                    facade.terminateDelinquents(ProcessManager.this.processList, this.timeLimit);
                }
            }
            catch (Exception ex) {
                log.debug("Unexpected error in terminteDelinquents", ex);
            }
        }
    }

    class IdleCheckTimerPrepareTask
    extends TimerTask {
        String serviceName;

        IdleCheckTimerPrepareTask(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public void run() {
            Thread.currentThread().setName(this.serviceName + "-IdleCheckTimerThread");
            LoggingContext loggingContext = loggingRealm.getLoggingContext();
            loggingContext.setSessionID("idleCheckTimer");
            loggingContext.setStepID("0");
            loggingContext.setRequestID("na");
            loggingContext.setSubRequestID("");
        }
    }
}

