/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.reportservice;

import com.cognos.pogo.bibus.RequestAffinity;
import com.cognos.pogo.monitoring.jmx.report.InteractiveReportList;
import com.cognos.pogo.reportservice.ProcessList;
import com.cognos.pogo.reportservice.ReportServerConnection;
import com.cognos.pogo.reportservice.ReportServerQueueCallback;
import com.cognos.pogo.reportservice.ReportServerRequest;
import com.cognos.pogo.reportservice.ReportServerRequestInformation;
import com.cognos.pogo.util.PogoLogger;
import java.rmi.NoSuchObjectException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.ConcurrentLinkedQueue;

public class ReportServerQueue
implements ReportServerQueueCallback,
InteractiveReportList {
    private static final PogoLogger log = PogoLogger.getLogger();
    private ConcurrentLinkedQueue<ReportServerRequest> queue = new ConcurrentLinkedQueue();
    private ProcessList processList;
    private long defaultTimeout;
    private boolean isShutdown;
    private boolean isSuspended;

    public void shutdown() {
        this.isShutdown = true;
        this.flush();
    }

    public void resume() {
        this.isSuspended = false;
    }

    public void suspend(boolean immediate) {
        this.isSuspended = true;
        if (immediate) {
            this.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flush() {
        LinkedList<ReportServerRequest> pendingRequests;
        ReportServerQueue reportServerQueue = this;
        synchronized (reportServerQueue) {
            if (this.queue.isEmpty()) {
                return;
            }
            pendingRequests = new LinkedList<ReportServerRequest>();
            pendingRequests.addAll(this.queue);
            this.queue.clear();
        }
        while (!pendingRequests.isEmpty()) {
            ReportServerRequest request = (ReportServerRequest)pendingRequests.removeFirst();
            request.setServiceStopped(true);
            ReportServerRequest reportServerRequest = request;
            synchronized (reportServerRequest) {
                request.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getQueueSize() {
        ReportServerQueue reportServerQueue = this;
        synchronized (reportServerQueue) {
            return this.queue.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNonAffineQueueSize() {
        int count = 0;
        ReportServerQueue reportServerQueue = this;
        synchronized (reportServerQueue) {
            for (ReportServerRequest request : this.queue) {
                if (request.getAffinity() != RequestAffinity.NONE) continue;
                ++count;
            }
        }
        return count;
    }

    private ReportServerRequest getNextNonAffineRequest() {
        return this.getNextRequest(false, -1, false);
    }

    private ReportServerRequest getNextRequest(boolean affineOnly, int processID, boolean isCancel) {
        ReportServerRequest nextRequest = null;
        if (this.queue.isEmpty()) {
            return null;
        }
        Iterator<ReportServerRequest> iterator = this.queue.iterator();
        if (affineOnly) {
            while (iterator.hasNext()) {
                nextRequest = iterator.next();
                if (!this.isValidAffineRequest(processID, isCancel, nextRequest)) continue;
                return nextRequest;
            }
        } else {
            while (iterator.hasNext()) {
                nextRequest = iterator.next();
                if (!this.isValidNonAffineRequest(processID, nextRequest)) continue;
                return nextRequest;
            }
        }
        return null;
    }

    private boolean isValidAffineRequest(int processID, boolean isCancel, ReportServerRequest nextRequest) {
        if (nextRequest.getAffinity() == RequestAffinity.NONE) {
            return false;
        }
        if (nextRequest.getAffinity() == RequestAffinity.SESSION) {
            return false;
        }
        if (nextRequest.getProcessID() != processID) {
            return false;
        }
        return nextRequest.getAffinity() == RequestAffinity.CONTROL == isCancel;
    }

    private boolean isValidNonAffineRequest(int processID, ReportServerRequest nextRequest) {
        if (nextRequest.getAffinity() == RequestAffinity.NONE) {
            return true;
        }
        return nextRequest.getProcessID() == processID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RequestAffinity wakeNextRequest(ReportServerConnection aConnection, int processID) {
        ReportServerRequest nextRequest = null;
        ReportServerQueue reportServerQueue = this;
        synchronized (reportServerQueue) {
            if (this.queue.isEmpty()) {
                return null;
            }
            boolean affineOnly = aConnection.isAffineOnly();
            nextRequest = this.getNextRequest(affineOnly, processID, aConnection.isCancelOnly());
            while (nextRequest != null) {
                this.removeReqFromQueue(nextRequest);
                ReportServerRequest reportServerRequest = nextRequest;
                synchronized (reportServerRequest) {
                    if (!nextRequest.hasServerConnection()) {
                        log.info("Assigned connection to ", nextRequest);
                        RequestAffinity requestAffinity = nextRequest.getAffinity();
                        if (requestAffinity == RequestAffinity.NONE) {
                            aConnection.setNonAffine(true);
                        } else {
                            aConnection.setNonAffine(false);
                        }
                        nextRequest.setServerConnection(aConnection);
                        nextRequest.notify();
                        return requestAffinity;
                    }
                }
                nextRequest = this.getNextRequest(affineOnly, processID, aConnection.isCancelOnly());
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getConnection(ReportServerRequest aRequest, long timeout) throws NoSuchObjectException {
        log.debug("Entering ReportServerQueue.getConnection(), timeout=", timeout);
        ReportServerConnection aConnection = null;
        ReportServerQueue reportServerQueue = this;
        synchronized (reportServerQueue) {
            if (aRequest.getAffinity() == RequestAffinity.NONE) {
                log.debug("Requesting non-affine connection...");
                aConnection = this.processList.getNonAffineConnection();
            } else {
                try {
                    RequestAffinity requestAffinity = aRequest.getAffinity();
                    this.logAffinity(requestAffinity);
                    aConnection = this.processList.getAffineConnection(aRequest.getProcessID(), requestAffinity);
                }
                catch (NoSuchObjectException ex) {
                    log.debug("Requested process (", aRequest.getProcessID(), ") does not exist... ");
                    if (this.isRequestProcessSpecific(aRequest)) {
                        log.debug("Leaving ReportServerQueue.getConnection() with no connection for control, get or absolute request.");
                        throw ex;
                    }
                    log.debug("Requesting non-affine connection... because the affine request requested a non-existent process");
                    timeout = this.getDefaultTimeout();
                    log.debug("changed queue timeout to default: ", timeout);
                    aRequest.setAffinity(RequestAffinity.NONE, timeout);
                    aConnection = this.processList.getNonAffineConnection();
                }
            }
            if (aConnection != null) {
                log.info("Assigned connection ", aConnection, " to ", aRequest);
                aRequest.setServerConnection(aConnection);
                log.debug("Leaving ReportServerQueue.getConnection()");
                return;
            }
            if (aRequest.isNonQueueable() && this.processList.isFull()) {
                log.debug("No connections available and no more processes to start. Rejecting non-queueable request.");
                return;
            }
            log.info("No requested connection available.  Adding request to the queue");
            this.addReqToQueue(aRequest);
        }
        if (this.isShutdown || this.isSuspended) {
            this.removeReqFromQueue(aRequest);
            aRequest.setServiceStopped(true);
            return;
        }
        long queueStartTime = System.currentTimeMillis();
        Object object = aRequest;
        synchronized (object) {
            if (!this.isRequestProcessSpecific(aRequest)) {
                log.debug("Sending hint that another process should be started");
                this.processList.createAnotherProcess();
            }
            try {
                if (!aRequest.hasServerConnection()) {
                    log.info("No connections are available.  The request is queued for at most ", timeout, " ms");
                    queueStartTime = System.currentTimeMillis();
                    aRequest.getRequestInfo().setQueueDepth(this.queue.size());
                    if (!this.isShutdown && !this.isSuspended) {
                        aRequest.wait(timeout);
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.isShutdown || this.isSuspended) {
            this.removeReqFromQueue(aRequest);
            aRequest.setServiceStopped(true);
            return;
        }
        if (!aRequest.hasServerConnection() && aRequest.getAffinity() != RequestAffinity.NONE) {
            if (this.isRequestProcessSpecific(aRequest)) {
                log.debug("Absolutely affine connection not retrieved within the time limit. Not switching to non-affined");
                object = this;
                synchronized (object) {
                    this.removeReqFromQueue(aRequest);
                }
                return;
            }
            log.info("Affine connection not retrieved within the time limit, switching to non-affine");
            timeout = this.getDefaultTimeout();
            aRequest.setAffinity(RequestAffinity.NONE, timeout);
            log.debug("Switching queue timeout limit to: ", timeout);
            object = this;
            synchronized (object) {
                aConnection = null;
                if (this.getNextNonAffineRequest() == aRequest && !aRequest.hasServerConnection() && (aConnection = this.processList.getNonAffineConnection()) != null) {
                    log.info("Got requested connection");
                    aRequest.getRequestInfo().setQueueTime(System.currentTimeMillis() - queueStartTime);
                    aRequest.setServerConnection(aConnection);
                    this.removeReqFromQueue(aRequest);
                    log.debug("Leaving ReportServerQueue.getConnection()");
                    return;
                }
                timeout = this.getDefaultTimeout();
            }
            object = aRequest;
            synchronized (object) {
                if (!aRequest.hasServerConnection()) {
                    try {
                        log.debug("Sending hint that another process should be started");
                        this.processList.createAnotherProcess();
                        log.info("No connections available.  Request is queued for at most ", timeout, " ms");
                        if (!this.isShutdown && !this.isSuspended) {
                            aRequest.wait(timeout);
                        } else {
                            aRequest.setServiceStopped(true);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
        if (!aRequest.hasServerConnection()) {
            log.debug("Could not get connection even after queueing (", aRequest.getAffinity(), ")");
        } else {
            log.debug("Got requested connection after queueing");
        }
        aRequest.getRequestInfo().setQueueTime(System.currentTimeMillis() - queueStartTime);
        object = this;
        synchronized (object) {
            this.removeReqFromQueue(aRequest);
        }
    }

    public void removeReqFromQueue(ReportServerRequest aRequest) {
        this.queue.remove(aRequest);
        aRequest.getRequestInfo().setQueueDepth(this.queue.size());
    }

    public void addReqToQueue(ReportServerRequest aRequest) {
        this.queue.add(aRequest);
        aRequest.getRequestInfo().setQueueDepth(this.queue.size());
    }

    protected boolean isRequestProcessSpecific(ReportServerRequest request) {
        return request.getAffinity().isProcessSpecific();
    }

    private void logAffinity(RequestAffinity requestAffinity) {
        if (requestAffinity == RequestAffinity.CONTROL) {
            log.debug("Requesting affine connection for cancel operation...");
        } else if (requestAffinity == RequestAffinity.SESSION) {
            log.debug("Requesting session affine connection...");
        } else if (requestAffinity == RequestAffinity.GET) {
            log.debug("Requesting get affine connection...");
        } else {
            log.debug("Requesting affine connection...");
        }
    }

    public void setProcessList(ProcessList aList) {
        this.processList = aList;
    }

    public synchronized long getDefaultTimeout() {
        return this.defaultTimeout;
    }

    @Override
    public synchronized void setDefaultTimeout(long newDefaultTimeout) {
        this.defaultTimeout = newDefaultTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ReportServerRequestInformation> getRequests() {
        ReportServerQueue reportServerQueue = this;
        synchronized (reportServerQueue) {
            return new ArrayList<ReportServerRequestInformation>(this.queue);
        }
    }
}

