/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.reportservice.temporary;

import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.reportservice.temporary.TemporaryObjectsTimer;
import com.cognos.pogo.util.Duration;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class TemporaryObjectsControl {
    private static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(TemporaryObjectsControl.class.getName());
    private static TemporaryObjectsTimer temporaryObjectsTimer = null;
    private String temporaryObjectsFolder;
    long temporaryObjectLifetime = 0L;
    public Configuration localConfiguration;

    public void configure(Configuration configuration) {
        if (configuration == null || temporaryObjectsTimer == null) {
            return;
        }
        this.localConfiguration = configuration;
        if (this.temporaryObjectsFolder == null || this.temporaryObjectsFolder.length() == 0) {
            this.temporaryObjectsFolder = this.localConfiguration.getICCLConfiguration().resolveEffectivePath(this.localConfiguration.getValue("temp"));
        }
        String tmpTTLString = configuration.getValue("temporaryObjectLifetime");
        try {
            long tmpTemporaryObjectLifetime;
            if (tmpTTLString != null && tmpTTLString.length() > 0 && (tmpTemporaryObjectLifetime = Duration.valueOf(tmpTTLString).getMilliseconds()) != this.temporaryObjectLifetime) {
                this.temporaryObjectLifetime = tmpTemporaryObjectLifetime;
                temporaryObjectsTimer.configure(this.temporaryObjectLifetime, this.temporaryObjectsFolder);
            }
        }
        catch (IllegalArgumentException e) {
            cat.warn("Configuration property 'temporaryObjectLifetime' did not return a duration ('PnDTnHnMnS').  Ignoring configuration update", (Throwable)e);
            return;
        }
    }

    public void start() {
        if (temporaryObjectsTimer == null) {
            temporaryObjectsTimer = new TemporaryObjectsTimer();
            temporaryObjectsTimer.start();
        }
    }

    public void stop() {
        if (temporaryObjectsTimer != null) {
            temporaryObjectsTimer.stop();
        }
    }

    public String getTemporaryObjectsLocation() {
        return this.temporaryObjectsFolder;
    }

    public long getTemporaryObjectsLifetime() {
        return this.temporaryObjectLifetime;
    }
}

