/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.reportservice.temporary;

import com.cognos.pogo.handlers.dispatchercache.CacheFileDescriptor;
import com.cognos.pogo.reportservice.temporary.CleanupExpiredSessionObjectsTimerTask;
import com.cognos.pogo.util.timer.PogoTimer;
import java.util.Timer;
import java.util.TimerTask;

public class TemporaryObjectsTimer {
    private static final long WAKEUP_TIME = 60000L;
    private Timer tempObjTimer = this.createTimer();
    private long temporaryObjectLifetime = 0L;
    private String temporaryObjectsFolder = null;
    private CleanupExpiredSessionObjectsTimerTask cleanupTimerTask;

    public void configure(long tmpObjectLifetime, String tmpObjectsFolder) {
        this.temporaryObjectsFolder = new CacheFileDescriptor(tmpObjectsFolder).getCacheLocation();
        if (this.temporaryObjectLifetime != tmpObjectLifetime) {
            this.temporaryObjectLifetime = tmpObjectLifetime;
            this.resetCleanupTimerTask();
            this.scheduleCleanupTimerTask();
        }
    }

    public void start() {
        if (null == this.cleanupTimerTask) {
            this.scheduleCleanupTimerTask();
        }
    }

    private void scheduleCleanupTimerTask() {
        if (this.isConfigured()) {
            this.scheduleCleanupTimerTaskIfConfigured();
        }
    }

    private boolean isConfigured() {
        return this.temporaryObjectsFolder != null && this.temporaryObjectLifetime > 0L;
    }

    private void scheduleCleanupTimerTaskIfConfigured() {
        this.cleanupTimerTask = new CleanupExpiredSessionObjectsTimerTask(this.temporaryObjectLifetime, this.temporaryObjectsFolder);
        this.tempObjTimer.schedule((TimerTask)this.cleanupTimerTask, 0L, 60000L);
    }

    private Timer createTimer() {
        String threadName = this.getClass().getSimpleName();
        return this.createTimer(threadName);
    }

    protected Timer createTimer(String threadName) {
        return PogoTimer.createNativeTimer(threadName);
    }

    public void stop() {
        if (null != this.cleanupTimerTask) {
            this.cleanupTimerTask.cancel();
        }
    }

    private void resetCleanupTimerTask() {
        if (this.cleanupTimerTask != null) {
            this.cleanupTimerTask.cancel();
            this.cleanupTimerTask = null;
        }
    }

    TimerTask getTimerTaskForUnitTest() {
        return this.cleanupTimerTask;
    }
}

