/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.reportservice.util;

import com.cognos.pogo.util.PogoLogger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

class ReportServerCommand {
    PogoLogger logger = PogoLogger.getLogger();
    int exitValue = 0;
    String cmd;
    String[] consoleOut = null;
    private ProcessBuilder builder;

    public ReportServerCommand(String cmd) {
        this.cmd = cmd;
        String[] cmdLineArgs = cmd.split(" ");
        this.builder = new ProcessBuilder(cmdLineArgs);
    }

    public String[] getConsoleOutput() {
        return this.consoleOut;
    }

    public int getexitCode() {
        return this.exitValue;
    }

    public void runCmd() {
        this.exitValue = -1;
        try {
            Process nativeProcess = this.builder.start();
            List<String> command = this.builder.command();
            this.logger.debug("Native process: ", command);
            this.getConsoleOutput(nativeProcess);
            nativeProcess.getErrorStream().close();
            nativeProcess.getInputStream().close();
            this.exitValue = nativeProcess.exitValue();
            this.logger.debug(this.cmd, ": exit value was ", this.exitValue);
        }
        catch (IllegalThreadStateException stateException) {
            this.logger.debug(this.cmd, ": the process was started successfully.");
            this.exitValue = -1;
        }
        catch (Exception e) {
            this.logger.debug(this.cmd + ": Exception caught ", e);
            this.exitValue = -1;
        }
    }

    private void getConsoleOutput(Process nativeProcess) throws IOException {
        BufferedReader aReader = new BufferedReader(new InputStreamReader(nativeProcess.getInputStream()));
        ArrayList<String> lineArray = new ArrayList<String>();
        String line = aReader.readLine();
        while (line != null) {
            this.logger.debug(this.cmd, ": ", line);
            this.addNonBlankLine(lineArray, line);
            line = aReader.readLine();
        }
        this.consoleOut = new String[lineArray.size()];
        lineArray.toArray(this.consoleOut);
    }

    private void addNonBlankLine(ArrayList<String> lineArray, String line) {
        if (!line.equals("")) {
            lineArray.add(line);
        }
    }
}

