/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.services;

import com.cognos.pogo.config.HandlerFactory;
import com.cognos.pogo.impl.DispatcherStrings;
import com.cognos.pogo.pdk.Handler;
import com.cognos.pogo.pdk.HandlerPool;
import com.cognos.pogo.pdk.InvalidServiceException;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.services.JMXConfigurableService;
import com.cognos.pogo.util.PogoIPFLog;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.dom4j.Element;

public class HandlerReadingService
extends JMXConfigurableService {
    private static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(HandlerReadingService.class.getName());
    protected HandlerPool handlers = new HandlerPool();
    protected Element element;

    @Override
    public HandlerPool contextualize(Element elem) throws InvalidServiceException {
        super.contextualize(elem);
        this.element = elem;
        this.cleanHandlerRefs(this.element);
        for (Element e : this.element.selectNodes("./*[local-name()='handlers']/*[local-name()='handler']")) {
            try {
                Handler handler = HandlerFactory.create(e, this.classLoader);
                String name = e.attributeValue("name");
                this.handlers.add(name, handler);
            }
            catch (PogoException ex) {
                cat.error("error contextualizing handler in service " + this.getName(), (Throwable)ex);
                Object[] args = new Object[]{this.getName(), ex.getMessage()};
                String errorMsg = DispatcherStrings.getInstance().getString("HandlerReadingService.contextualize", args);
                PogoIPFLog.getInstance().logStartupError(errorMsg);
            }
        }
        return this.handlers;
    }

    protected void cleanHandlerRefs(Element elem) {
        for (Element e : this.element.selectNodes("//handler_ref")) {
            String name = e.attributeValue("name");
            if (name.indexOf(".") != -1) continue;
            e.addAttribute("name", this.getName() + "." + name);
        }
    }
}

