/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.services;

import com.cognos.pogo.impl.DispatcherStrings;
import com.cognos.pogo.pdk.PogoConfigException;
import com.cognos.pogo.pdk.Service;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.dom4j.Element;

public class ServiceFactory {
    private static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(ServiceFactory.class.getName());

    public static Service create(Element serviceElement, ClassLoader classLoader) throws PogoConfigException {
        String stoppable;
        String forceCMDefaultName;
        String logStartStop;
        String unloadPriority;
        Object o;
        String serviceName = serviceElement.attributeValue("name");
        if (serviceName == null || serviceName.length() == 0) {
            String errorMsg = DispatcherStrings.getInstance().getString("ServiceFactory.noName");
            throw new PogoConfigException(errorMsg);
        }
        String serviceClass = serviceElement.attributeValue("class");
        if (serviceClass == null || serviceClass.length() == 0) {
            Object[] args = new Object[]{serviceName};
            String errorMsg = DispatcherStrings.getInstance().getString("ServiceFactory.noClass", args);
            throw new PogoConfigException(errorMsg);
        }
        cat.debug("creating pogo service " + serviceName + " of type " + serviceClass);
        try {
            Class<?> clazz = classLoader == null ? Class.forName(serviceClass) : Class.forName(serviceClass, true, classLoader);
            o = clazz.newInstance();
        }
        catch (Throwable x) {
            cat.error("cannot instantiate service class " + serviceClass + ", Service Ignored");
            Object[] args = new Object[]{serviceName, serviceClass};
            String errorMsg = DispatcherStrings.getInstance().getString("ServiceFactory.cantInstantiate", args);
            throw new PogoConfigException(errorMsg);
        }
        if (!(o instanceof Service)) {
            cat.error("Service class \"" + serviceClass + "\" does not implement com.cognos.pogo.pdk.Service,  Service Ignored");
            Object[] args = new Object[]{serviceName, serviceClass};
            String errorMsg = DispatcherStrings.getInstance().getString("ServiceFactory.notService", args);
            throw new PogoConfigException(errorMsg);
        }
        Service service = (Service)o;
        service.setName(serviceName);
        String loadPriority = serviceElement.attributeValue("loadPriority");
        if (loadPriority != null && loadPriority.length() > 0) {
            service.setLoadPriority(Integer.parseInt(loadPriority));
        }
        if ((unloadPriority = serviceElement.attributeValue("unloadPriority")) != null && unloadPriority.length() > 0) {
            service.setUnloadPriority(Integer.parseInt(unloadPriority));
        }
        if ("false".equalsIgnoreCase(logStartStop = serviceElement.attributeValue("logStartStop"))) {
            service.setLogStartStop(false);
        }
        if ("true".equalsIgnoreCase(forceCMDefaultName = serviceElement.attributeValue("forceCMDefaultName"))) {
            service.setForceCMDefaultName(true);
        }
        if ("false".equalsIgnoreCase(stoppable = serviceElement.attributeValue("stoppable"))) {
            service.setSuspendable(false);
        }
        service.setClassLoader(classLoader);
        return service;
    }
}

