/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.services.concurrent;

import com.cognos.pogo.config.ConfigurationImpl;
import com.cognos.pogo.logging.LoggingRealm;
import com.cognos.pogo.logging.LoggingRealmFactory;
import com.cognos.pogo.logging.Slogger;
import com.cognos.pogo.logging.messages.ServiceErrorAuditMsg;
import com.cognos.pogo.logging.messages.ServiceEventAuditMsg;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.Service;
import com.cognos.pogo.services.DispatcherServices;
import com.cognos.pogo.util.PogoLogger;
import java.text.MessageFormat;
import java.util.concurrent.Callable;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class ServiceExecutor
implements Callable<Void> {
    static final LoggingRealm loggingRealm = LoggingRealmFactory.getInstance("DISP");
    static final Slogger slogger = loggingRealm.getLogger(DispatcherServices.class.getName());
    private static final PogoLogger cat = PogoLogger.getLoggerFor(ServiceExecutor.class.getName());
    private static final Logger catStatus = Hierarchy.getDefaultHierarchy().getLoggerFor("STATUS." + DispatcherServices.class.getName());
    private static final String startServiceSuccess = "StartService".concat(" {0} ").concat("Success");
    private Service service;

    public ServiceExecutor(Service service) {
        this.service = service;
    }

    public Service getService() {
        return this.service;
    }

    @Override
    public Void call() throws Exception {
        return null;
    }

    public Void start() throws Exception {
        try {
            cat.debug("Attempting to start service: " + this.service.getName());
            this.service.start();
            if (this.service.isLogStartStop()) {
                String serviceName = this.service.getCMdefaultName();
                if (serviceName == null) {
                    serviceName = this.service.getName();
                }
                catStatus.info(MessageFormat.format(startServiceSuccess, serviceName));
                slogger.log(new ServiceEventAuditMsg(serviceName, "StartService"));
            }
        }
        catch (Exception e) {
            cat.error("error in start of service " + this.service.getName(), e);
            this.logErrorMessage(e);
            ServiceErrorAuditMsg msg = new ServiceErrorAuditMsg(this.service.getName(), "StartService");
            msg.addErrorMessage(e);
            slogger.log(msg);
        }
        catch (LinkageError le) {
            cat.error("LinkageError in start of service " + this.service.getName(), le);
            this.logErrorMessage(le);
        }
        return null;
    }

    private void logErrorMessage(Throwable le) {
        ServiceErrorAuditMsg msg = new ServiceErrorAuditMsg(this.service.getName(), "StartService");
        msg.addErrorMessage(le);
        slogger.log(msg);
    }

    public Void configure(Configuration configuration) {
        try {
            ConfigurationImpl serviceconfig = new ConfigurationImpl(configuration);
            cat.debug("Attempting to configure service: ", this.service.getName());
            if (this.service.getLoadPriority() <= 0) {
                this.service.reconfigure(serviceconfig);
            } else {
                this.service.configure(serviceconfig);
            }
        }
        catch (Exception e) {
            cat.error("error in configure of service " + this.service.getName(), e);
            ServiceErrorAuditMsg msg = new ServiceErrorAuditMsg(this.service.getName(), "configure");
            msg.addErrorMessage(e);
            slogger.log(msg);
        }
        catch (LinkageError le) {
            cat.error("LinkageError in configure of service " + this.service.getName(), le);
            ServiceErrorAuditMsg msg = new ServiceErrorAuditMsg(this.service.getName(), "configure");
            msg.addErrorMessage(le);
            slogger.log(msg);
        }
        return null;
    }

    public Void reconfigure(Configuration configuration) {
        try {
            ConfigurationImpl serviceconfig = new ConfigurationImpl(configuration);
            cat.debug("Attempting to reconfigure service: ", this.service.getName());
            this.service.reconfigure(serviceconfig);
        }
        catch (Exception e) {
            cat.error("error in reconfigure of service " + this.service.getName(), e);
            ServiceErrorAuditMsg msg = new ServiceErrorAuditMsg(this.service.getName(), "reconfigure");
            msg.addErrorMessage(e);
            slogger.log(msg);
        }
        catch (LinkageError le) {
            cat.error("LinkageError in reconfigure of service " + this.service.getName(), le);
            ServiceErrorAuditMsg msg = new ServiceErrorAuditMsg(this.service.getName(), "reconfigure");
            msg.addErrorMessage(le);
            slogger.log(msg);
        }
        return null;
    }

    public ServiceExecutor getOperation(OperationType operationType, Configuration configuration) {
        return operationType.getServiceExecutor(this.service, configuration);
    }

    public static enum OperationType {
        START(false, "Starting"){

            @Override
            public ServiceExecutor getServiceExecutor(Service service, Configuration configuration) {
                return new ServiceExecutor(service){

                    @Override
                    public Void call() throws Exception {
                        return this.start();
                    }
                };
            }
        }
        ,
        CONFIGURE(true, "Configuring"){

            @Override
            public ServiceExecutor getServiceExecutor(Service service, final Configuration configuration) {
                return new ServiceExecutor(service){

                    @Override
                    public Void call() throws Exception {
                        return this.configure(configuration);
                    }
                };
            }
        }
        ,
        RECONFIGURE(true, "Reconfiguring"){

            @Override
            public ServiceExecutor getServiceExecutor(Service service, final Configuration configuration) {
                return new ServiceExecutor(service){

                    @Override
                    public Void call() throws Exception {
                        return this.reconfigure(configuration);
                    }
                };
            }
        };

        private boolean always;
        private String verb;

        public abstract ServiceExecutor getServiceExecutor(Service var1, Configuration var2);

        private OperationType(boolean always, String verb) {
            this.always = always;
            this.verb = verb;
        }

        public boolean always() {
            return this.always;
        }

        public Object getVerb() {
            return this.verb;
        }
    }
}

