/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.stax.connection;

import com.cognos.p2plb.model.NodeID;
import com.cognos.pogo.http.ServerConnection;
import com.cognos.pogo.http.httpclient.MsgBodyGenerator;
import com.cognos.pogo.stax.SOAPFault;
import com.cognos.pogo.stax.SOAPMessage;
import com.cognos.pogo.stax.connection.SOAPConnectionImpl;
import com.cognos.pogo.transport.DispatcherConnectionManager;
import com.cognos.pogo.util.PerfLogger;
import com.cognos.pogo.util.PerfTimer;
import com.cognos.pogo.util.PogoLogger;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import javax.xml.stream.XMLStreamException;

public class BusConnectionImpl
extends SOAPConnectionImpl {
    public static String BUS_DISPATCHER = "bus://dispatcher";
    public static String BUS_CM = "bus://cm";
    private static PogoLogger log = PogoLogger.getLogger();
    private PerfLogger perfLogger;
    private ServerConnection conn;
    private String cmPath;
    private String dispatcherPath;
    private final NodeID nodeID;

    public BusConnectionImpl(PerfLogger perfLogger, String cmPath, String dispatcherPath) {
        this(perfLogger, cmPath, dispatcherPath, null);
    }

    public BusConnectionImpl(PerfLogger perfLogger, String cmPath, String dispatcherPath, NodeID nodeID) {
        super(perfLogger);
        this.cmPath = cmPath;
        this.dispatcherPath = dispatcherPath;
        this.nodeID = nodeID;
        this.perfLogger = perfLogger.cloneIfEnabled(this.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(final SOAPMessage message, String urlString) throws MalformedURLException, SOAPFault, IOException, XMLStreamException {
        String url;
        PerfTimer executeTimer = null;
        if (urlString.startsWith(BUS_DISPATCHER)) {
            executeTimer = this.perfLogger.startTimer(PerfLogger.Level.LEVEL2, "execute", BUS_DISPATCHER);
            this.conn = this.getDispatcherConnection();
            url = this.dispatcherPath + urlString.substring(BUS_DISPATCHER.length());
        } else if (urlString.startsWith(BUS_CM)) {
            executeTimer = this.perfLogger.startTimer(PerfLogger.Level.LEVEL2, "execute", BUS_CM);
            this.conn = DispatcherConnectionManager.getContentManagerConnection();
            url = this.cmPath + urlString.substring(BUS_CM.length());
        } else {
            super.execute(message, urlString);
            return;
        }
        String soapAction = message.getSOAPAction();
        if (soapAction != null) {
            this.conn.setRequestHeader("SOAPAction", soapAction);
        }
        this.conn.addRequestHeader("Content-Type", "text/xml; charset=utf-8");
        this.conn.addRequestHeader("Connection", "Keep-Alive");
        this.conn.setRequestBodySource(new MsgBodyGenerator(){

            @Override
            public boolean rewind() {
                return false;
            }

            @Override
            public void writeBody(OutputStream os) throws IOException {
                BufferedWriter writerOutput = new BufferedWriter(new OutputStreamWriter(os, "UTF-8"));
                BusConnectionImpl.this.writeRequest(message, writerOutput, true);
                ((Writer)writerOutput).flush();
            }
        });
        this.logRequest(message);
        try {
            PerfTimer sendRequestTimer = this.perfLogger.startTimer(PerfLogger.Level.LEVEL2, "execute", "Send SOAP Request");
            int result = this.conn.sendRequest(url);
            this.perfLogger.stopTimer(sendRequestTimer);
            BufferedInputStream input = new BufferedInputStream(this.conn.getInputStream(), 4096);
            if (result >= 400 && result != 500) {
                log.error("SOAP Connection response code: ", result);
                throw new IOException("SOAP Connection error " + result + " : " + this.conn.getStatusText());
            }
            String contentTypeValue = this.conn.getResponseContentType();
            this.processResponse(message, input, contentTypeValue);
        }
        finally {
            this.disconnect();
            this.perfLogger.stopTimer(executeTimer);
        }
    }

    private ServerConnection getDispatcherConnection() {
        return this.nodeID != null ? DispatcherConnectionManager.getRemoteDispatcherConnection(this.nodeID) : DispatcherConnectionManager.getLocalDispatcherConnection();
    }

    @Override
    public void disconnect() {
        this.conn.release();
    }
}

