/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.stax.utils;

import com.cognos.pogo.pdk.BIBusEnvelope;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Entity;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.QName;

public class DOM4jXMLStreamWriter
implements XMLStreamWriter {
    private static final String BUS_URI = BIBusEnvelope.NS_BUS.getURI();
    private static final String BUS_PREFIX = BIBusEnvelope.NS_BUS.getPrefix();
    private static final String[] BUS_ELEMENTS = new String[]{BIBusEnvelope.BUS_TRACKING.getName(), BIBusEnvelope.BUS_HDR_SESSION.getName(), BIBusEnvelope.BUS_ENVIRONMENT_VARS.getName(), BIBusEnvelope.BUS_FORM_FIELD_VARS.getName(), BIBusEnvelope.BUS_COOKIE_VARS.getName(), BIBusEnvelope.BUS_DISPATCHER_TRANSPORT_VARS.getName(), BIBusEnvelope.BUS_CAM.getName(), BIBusEnvelope.BUS_CAF.getName(), BIBusEnvelope.BUS_USER_PREFERENCE_VARS.getName(), BIBusEnvelope.BUS_USER_CAPABILITIES_CACHE.getName(), BIBusEnvelope.BUS_CONVERSATION_CONTEXT.getName()};
    private static final Map<String, String> entityRefs = new HashMap<String, String>();
    private final Document doc;
    private final boolean forceBusNamespace;
    private Node currentNode;
    private String defaultNS;
    private Namespace defaultNamespace;
    private Element rootElement;

    public DOM4jXMLStreamWriter(boolean forceBusNamespace) {
        this.forceBusNamespace = forceBusNamespace;
        this.doc = DocumentHelper.createDocument();
    }

    @Override
    public void close() throws XMLStreamException {
    }

    @Override
    public void flush() throws XMLStreamException {
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return null;
    }

    @Override
    public String getPrefix(String arg0) throws XMLStreamException {
        return null;
    }

    @Override
    public Object getProperty(String arg0) throws IllegalArgumentException {
        return null;
    }

    @Override
    public void setDefaultNamespace(String uri) throws XMLStreamException {
        this.defaultNS = uri;
    }

    @Override
    public void setNamespaceContext(NamespaceContext arg0) throws XMLStreamException {
    }

    @Override
    public void setPrefix(String arg0, String arg1) throws XMLStreamException {
    }

    @Override
    public void writeAttribute(String localName, String value) throws XMLStreamException {
        this.getCurrentNode().addAttribute(localName, value);
    }

    private Element getCurrentNode() {
        return (Element)this.currentNode;
    }

    @Override
    public void writeAttribute(String namespaceURI, String localName, String value) throws XMLStreamException {
        this.getCurrentNode().addAttribute(this.getQName(namespaceURI, localName), value);
    }

    private QName getQName(String prefix, String uri, String localName) {
        Namespace ns = DocumentHelper.createNamespace((String)prefix, (String)uri);
        return DocumentHelper.createQName((String)localName, (Namespace)ns);
    }

    private QName getQName(String uri, String localName) {
        Namespace ns = Namespace.get((String)uri);
        return DocumentHelper.createQName((String)localName, (Namespace)ns);
    }

    @Override
    public void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
        this.getCurrentNode().addAttribute(this.getQName(prefix, namespaceURI, localName), value);
    }

    @Override
    public void writeCData(String data) throws XMLStreamException {
        this.getCurrentNode().add(DocumentHelper.createCDATA((String)data));
    }

    @Override
    public void writeCharacters(String text) throws XMLStreamException {
        this.getCurrentNode().add(DocumentHelper.createText((String)text));
    }

    @Override
    public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
        this.getCurrentNode().add(DocumentHelper.createText((String)new String(text, start, len)));
    }

    @Override
    public void writeComment(String data) throws XMLStreamException {
        this.getCurrentNode().add(DocumentHelper.createComment((String)data));
    }

    @Override
    public void writeDTD(String dtd) throws XMLStreamException {
    }

    @Override
    public void writeDefaultNamespace(String namespaceURI) throws XMLStreamException {
        this.defaultNS = namespaceURI;
        this.defaultNamespace = Namespace.get((String)namespaceURI);
        this.doc.getRootElement().add(this.defaultNamespace);
    }

    @Override
    public void writeEmptyElement(String localName) throws XMLStreamException {
        this.addElement(localName);
    }

    private void addElement(String localName) {
        if (this.currentNode == null) {
            this.doc.add(DocumentHelper.createElement((String)localName));
            this.rootElement = this.doc.getRootElement();
            this.currentNode = this.rootElement;
        } else {
            Element element = this.createElement(localName);
            this.getCurrentNode().add(element);
            this.currentNode = element;
        }
    }

    private Element createElement(String localName) {
        if (this.hasDefaultNamespace()) {
            return DocumentHelper.createElement((QName)DocumentHelper.createQName((String)localName, (Namespace)this.defaultNamespace));
        }
        return DocumentHelper.createElement((String)localName);
    }

    private boolean hasDefaultNamespace() {
        return this.defaultNS != null && this.defaultNamespace != this.getCurrentNode().getNamespace();
    }

    @Override
    public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
        this.addElement(namespaceURI, localName);
    }

    private void addElement(String namespaceURI, String localName) {
        if (this.currentNode == null) {
            this.doc.add(DocumentHelper.createElement((QName)this.getQName(namespaceURI, localName)));
            this.rootElement = this.doc.getRootElement();
            this.currentNode = this.rootElement;
        } else {
            Element element = DocumentHelper.createElement((QName)this.getQName(namespaceURI, localName));
            this.getCurrentNode().add(element);
            this.currentNode = element;
        }
    }

    @Override
    public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.addElement(prefix, localName, namespaceURI);
    }

    private void addElement(String prefix, String localName, String namespaceURI) {
        if (this.currentNode == null) {
            this.doc.add(DocumentHelper.createElement((QName)this.getQName(prefix, namespaceURI, localName)));
            this.rootElement = this.doc.getRootElement();
            this.currentNode = this.rootElement;
        } else {
            Element element = DocumentHelper.createElement((QName)this.getQName(prefix, namespaceURI, localName));
            this.getCurrentNode().add(element);
            this.currentNode = element;
        }
    }

    @Override
    public void writeEndDocument() throws XMLStreamException {
        this.currentNode = null;
    }

    @Override
    public void writeEndElement() throws XMLStreamException {
        this.currentNode = this.currentNode.getParent() != null ? this.currentNode.getParent() : this.rootElement;
    }

    @Override
    public void writeEntityRef(String name) throws XMLStreamException {
        this.getCurrentNode().add(this.getEntityRef(name));
    }

    private Entity getEntityRef(String name) {
        if (name == null) {
            return null;
        }
        String val = entityRefs.get(name);
        return val != null ? DocumentHelper.createEntity((String)name, (String)val) : null;
    }

    @Override
    public void writeNamespace(String prefix, String namespaceURI) throws XMLStreamException {
        Namespace ns = DocumentHelper.createNamespace((String)prefix, (String)namespaceURI);
        this.doc.getRootElement().add(ns);
        this.getCurrentNode().addAttribute(this.getQName(prefix, namespaceURI, "xmlns"), namespaceURI);
    }

    @Override
    public void writeProcessingInstruction(String target) throws XMLStreamException {
    }

    @Override
    public void writeProcessingInstruction(String target, String data) throws XMLStreamException {
    }

    @Override
    public void writeStartDocument() throws XMLStreamException {
    }

    @Override
    public void writeStartDocument(String version) throws XMLStreamException {
        this.getDocElement().addAttribute("version", version);
    }

    private Element getDocElement() {
        return (Element)this.doc;
    }

    @Override
    public void writeStartDocument(String encoding, String version) throws XMLStreamException {
        this.getDocElement().addAttribute("version", version);
        this.getDocElement().addAttribute("encoding", encoding);
    }

    @Override
    public void writeStartElement(String localName) throws XMLStreamException {
        if (this.forceBusNamespace && localName != null) {
            for (String busElement : BUS_ELEMENTS) {
                if (!busElement.equals(localName)) continue;
                this.writeStartElement(BUS_PREFIX, localName, BUS_URI);
                return;
            }
        }
        this.addElement(localName);
    }

    @Override
    public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
        this.addElement(namespaceURI, localName);
    }

    @Override
    public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        if (this.mustOverrideNamespace(prefix, localName)) {
            this.writeStartElement(BUS_PREFIX, localName, namespaceURI);
        } else {
            this.addElement(prefix, localName, namespaceURI);
        }
    }

    private boolean mustOverrideNamespace(String prefix, String localName) {
        return this.forceBusNamespace && "".equals(prefix) && "biBusHeader".equals(localName);
    }

    public Element toElement() {
        return this.doc.getRootElement();
    }

    public Document getDocument() {
        return this.doc;
    }

    static {
        entityRefs.put("quot", "&quot;");
        entityRefs.put("amp", "&amp;");
        entityRefs.put("apos", "&apos;");
        entityRefs.put("lt", "&lt;");
        entityRefs.put("gt", "&gt;");
    }
}

