/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.stax.utils;

import com.cognos.pogo.stax.utils.StaxMapEntry;
import com.cognos.pogo.stax.utils.StaxVars;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public abstract class StaxVarsList
extends StaxVars {
    private static final List<StaxMapEntry> EMPTY_LIST = Collections.emptyList();
    protected List<StaxMapEntry> vars;

    public StaxVarsList() {
        this.vars = EMPTY_LIST;
    }

    public StaxVarsList(StaxVarsList source) {
        this.vars = this.cloneList(source.vars);
    }

    private List<StaxMapEntry> cloneList(List<StaxMapEntry> source) {
        if (source.isEmpty()) {
            return EMPTY_LIST;
        }
        List<StaxMapEntry> clone = this.createList(source.size());
        for (StaxMapEntry entry : source) {
            clone.add(this.cloneMapEntry(entry));
        }
        return clone;
    }

    @Override
    protected void createCollection(int size) {
        this.vars = this.createList(size);
    }

    private List<StaxMapEntry> createList(int size) {
        return new ArrayList<StaxMapEntry>(size);
    }

    @Override
    public boolean isPresent() {
        return this.vars != EMPTY_LIST;
    }

    @Override
    protected void saveEntry(StaxMapEntry entry) {
        this.add(entry);
    }

    public StaxMapEntry get(String key) {
        for (StaxMapEntry entry : this.vars) {
            if (!StringUtils.equals((String)entry.getName(), (String)key)) continue;
            return entry;
        }
        return null;
    }

    public void add(StaxMapEntry value) {
        if (this.vars == EMPTY_LIST) {
            this.vars = this.createList(10);
        }
        this.vars.add(value);
    }

    public void clear() {
        if (this.vars != EMPTY_LIST) {
            this.vars.clear();
        }
    }

    public void remove(String key) {
        StaxMapEntry entry = this.get(key);
        if (entry != null) {
            this.vars.remove(entry);
        }
    }

    @Override
    public int size() {
        return this.vars.size();
    }

    @Override
    public Collection<StaxMapEntry> getValues() {
        return Collections.unmodifiableCollection(this.vars);
    }
}

