/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.transport;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.i18n.ToolkitResources;
import com.cognos.pogo.auth.CookieDecoder;
import com.cognos.pogo.auth.CookieQuoter;
import com.cognos.pogo.bibus.CryptoFacility;
import com.cognos.pogo.handlers.contentmanager.viewer.SoapEncodingUtils;
import com.cognos.pogo.impl.PogoResponder;
import com.cognos.pogo.impl.PogoSOAPAttachmentResponder;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.MCUtils;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.cognos.pogo.pdk.common.FormFieldVars;
import com.cognos.pogo.pdk.performance.listener.PerformanceEventListener;
import com.cognos.pogo.pdk.xml.PooledSAXReader;
import com.cognos.pogo.pdk.xml.SAXReaderPool;
import com.cognos.pogo.transport.MethodParameterExtractor;
import com.cognos.pogo.transport.ParamBucket;
import com.cognos.pogo.transport.RequestProcessor;
import com.cognos.pogo.transport.url2soap.ParameterList;
import com.cognos.pogo.transport.url2soap.URLToSOAP;
import com.cognos.pogo.transport.url2soap.Url2SOAPParseException;
import com.cognos.pogo.util.PogoLogger;
import com.cognos.pogo.util.StringUtils;
import com.ibm.cognos.internal.ombridge.BridgeHandler;
import java.io.BufferedReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.mail.internet.InternetHeaders;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.util.ParameterParser;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class FormRequestProcessor
extends RequestProcessor {
    private static final PogoLogger cat = PogoLogger.getLogger();
    private static final String PATH_INFO = "path_info";
    public static final String SOAPACTION_PREFIX = "\"http://developer.cognos.com/schemas/bibus/3#";
    public static final String SOAPACTION_C10_SERVICE_PREFIX = "http://www.ibm.com/xmlns/prod/cognos/";
    public static String C10_SERVICE_VERSION_SUFFIX;
    public static String C10_SERVICE_VERSION;
    public static String CONTENT_MANAGER_SERVICE;
    static final String DEFAULT_VERSION = "201505";
    public static final String DISPATCHER_SERVICE = "\"http://developer.cognos.com/schemas/bibus/3#dispatcher\"";
    public static final String DISPATCHER_CACHE_SERVICE_SERVER_AFFINITY = "dc.server";
    public static final String REPORTSERVER_CACHE_SERVICE_GET_AFFINITY = "rc.get";
    public static final String JOB_AND_SCHEDULE_MONITORING_SERVICE = "\"http://developer.cognos.com/schemas/bibus/3#jobAndScheduleMonitoringService\"";
    public static final String METADATA_SERVICE = "\"http://developer.cognos.com/schemas/bibus/3#metadataService\"";
    public static final String PRESENTATION_SERVICE = "\"http://developer.cognos.com/schemas/bibus/3#presentationService\"";
    public static final String REPORT_SERVICE = "\"http://developer.cognos.com/schemas/bibus/3#reportService\"";
    public static final String REPORT_SERVICE_HIGH_AFFINITY = "\"http://developer.cognos.com/schemas/bibus/3#reportService.high\"";
    public static final String REPORT_SERVICE_ABSOLUTE_AFFINITY = "\"http://developer.cognos.com/schemas/bibus/3#reportService.absolute\"";
    public static final String SYSTEM_SERVICE = "\"http://developer.cognos.com/schemas/bibus/3#systemService.absolute\"";
    public static final String POWERPLAY_SERVICE = "\"http://developer.cognos.com/schemas/bibus/3#powerPlayService\"";
    public static final String DISPATCHER_CACHE_SOAP_ACTION = "dc";
    public static final String REPORTSERVER_CACHE_SOAP_ACTION = "rc";
    private static final String WSDL_SERVICE = "wsdl";
    private static Map<String, String> methodToSoapActionMap;
    private String soapAction;
    private static Boolean isCamDisabled;

    protected FormRequestProcessor(String[][] extraHeaders) {
        super(extraHeaders);
    }

    protected static String getCurrentServiceVersion() {
        try {
            List supportedVersions = BridgeHandler.getSupportedVersions();
            return (String)supportedVersions.get(0);
        }
        catch (Error e) {
            cat.warn("BridgeHandler threw the error ", e);
            return DEFAULT_VERSION;
        }
        catch (Exception ex) {
            cat.warn("BridgeHandler threw the exception ", ex);
            return DEFAULT_VERSION;
        }
    }

    @Override
    String getFormRequestBody(HttpServletRequest req, String cafModifiedQueryString) throws IOException {
        String squery = this.getQueryFromRequest(req, cafModifiedQueryString);
        squery = this.maybeEncryptPasswords(req, squery);
        cat.debug("query string:", squery);
        return squery;
    }

    protected String getQueryFromRequest(HttpServletRequest req, String cafModifiedQueryString) throws IOException {
        String squery;
        if (req.getMethod().equals("GET")) {
            squery = cafModifiedQueryString;
            cat.debug("Dispatcher received a GET request");
        } else {
            ServletInputStream inStream = req.getInputStream();
            BufferedReader rdr = new BufferedReader(new InputStreamReader((InputStream)inStream));
            squery = rdr.readLine();
            cat.debug("Dispatcher received a POST request");
            String urlQueryString = cafModifiedQueryString;
            cat.debug("Query string on URL on a POST request: ", urlQueryString);
            if (urlQueryString != null) {
                if (squery == null || "".equals(squery)) {
                    squery = urlQueryString;
                } else {
                    StringBuffer strBuf = new StringBuffer(squery);
                    strBuf.append('&').append(urlQueryString);
                    squery = strBuf.toString();
                }
            }
        }
        return squery;
    }

    protected String maybeEncryptPasswords(HttpServletRequest req, String squery) throws UnsupportedEncodingException {
        if (req.getHeader("Cognos-Gateway") == null) {
            try {
                squery = FormRequestProcessor.encryptPasswordsInQueryString(squery, this.getCamFactory());
            }
            catch (CAMCryptoException cce) {
                cat.error("Unable to encrypt password", cce);
            }
        }
        return squery;
    }

    private CAMFactory getCamFactory() throws CAMCryptoException {
        return FormRequestProcessor.isCamDisabled() ? null : CryptoFacility.getCAMFactory();
    }

    private static boolean isCamDisabled() {
        if (isCamDisabled == null) {
            isCamDisabled = Boolean.valueOf(System.getProperty("cam.disable"));
        }
        return isCamDisabled;
    }

    private void copyHttpRequestParametersToEnvironmentVars(BIBusEnvelope requestEnvelope, HttpServletRequest request, MessageContext mc) {
        String sOrigHostHeader;
        String sOrigAuthType;
        String sCAMNamespace = request.getHeader("CAM-Namespace");
        if (sCAMNamespace != null) {
            this.setEnvironment(requestEnvelope, "CAMNamespace", sCAMNamespace);
        }
        if ((sOrigAuthType = request.getHeader("Original-Auth-Type")) == null || sOrigAuthType.length() == 0) {
            this.setEnvironment(requestEnvelope, "AUTH_TYPE", request.getAuthType());
        } else {
            this.setEnvironment(requestEnvelope, "AUTH_TYPE", request.getHeader("Original-Auth-Type"));
        }
        this.setEnvironment(requestEnvelope, "REQUEST_METHOD", request.getMethod());
        String pathInfo = mc.getStrProperty(PATH_INFO);
        this.setEnvironment(requestEnvelope, "PATH_INFO", pathInfo);
        String sOrigScriptName = request.getHeader("Original-Script-Name");
        if (sOrigScriptName == null || sOrigScriptName.length() == 0) {
            StringBuffer sb = new StringBuffer(request.getContextPath());
            sb.append(request.getServletPath());
            this.setEnvironment(requestEnvelope, "SCRIPT_NAME", sb.toString());
            this.setEnvironment(requestEnvelope, "SERVER_NAME", request.getServerName());
            this.setEnvironment(requestEnvelope, "SERVER_PORT", Integer.toString(request.getServerPort()));
        } else {
            this.setEnvironment(requestEnvelope, "SCRIPT_NAME", request.getHeader("Original-Script-Name"));
            this.setEnvironment(requestEnvelope, "SERVER_NAME", request.getHeader("Original-Host"));
            this.setEnvironment(requestEnvelope, "SERVER_PORT", request.getHeader("Original-Server_Port"));
        }
        this.setEnvironment(requestEnvelope, "HTTP_USER_AGENT", request.getHeader("user-agent"));
        String acceptLang = request.getHeader("accept-language");
        if (acceptLang != null) {
            String normalizedLang = ToolkitResources.normalizeLocaleIdentifier((String)acceptLang);
            this.setEnvironment(requestEnvelope, "HTTP_ACCEPT_LANGUAGE", normalizedLang);
        }
        if ((sOrigHostHeader = request.getHeader("Original-Host-Header")) == null || sOrigHostHeader.length() == 0) {
            this.setEnvironment(requestEnvelope, "HTTP_HOST", request.getHeader("host"));
        } else {
            this.setEnvironment(requestEnvelope, "HTTP_HOST", request.getHeader("Original-Host-Header"));
        }
        String originalServerProtocol = request.getHeader("Original-Server-Protocol");
        if (originalServerProtocol == null || originalServerProtocol.length() == 0) {
            this.setEnvironment(requestEnvelope, "SERVER_PROTOCOL", request.getProtocol());
        } else {
            this.setEnvironment(requestEnvelope, "SERVER_PROTOCOL", originalServerProtocol);
        }
        String sOrigRemoteUser = request.getHeader("Original-Remote-User");
        if (sOrigRemoteUser == null || sOrigRemoteUser.length() == 0) {
            this.setEnvironment(requestEnvelope, "REMOTE_USER", request.getRemoteUser());
        } else {
            this.setEnvironment(requestEnvelope, "REMOTE_USER", request.getHeader("Original-Remote-User"));
        }
        this.setEnvironment(requestEnvelope, "REMOTE_ADDR", request.getRemoteAddr());
        String sServerSessionSpec = request.getHeader("http_sm_serversessionspec");
        if (sServerSessionSpec != null && sServerSessionSpec.length() != 0) {
            this.setEnvironment(requestEnvelope, "HTTP_SM_SERVERSESSIONSPEC", sServerSessionSpec);
        }
        this.addExtraHeaders(request, requestEnvelope);
    }

    private void setEnvironment(BIBusEnvelope requestEnvelope, String name, String value) {
        requestEnvelope.setEnvironment(name, value != null ? value : "");
    }

    private void copyUrlParametersToFormFieldVars(BIBusEnvelope requestEnvelope, ParamBucket param_bucket) {
        Iterator<String> itnames = param_bucket.getNames();
        while (itnames.hasNext()) {
            String name = itnames.next();
            Vector<String> values = param_bucket.getValues(name);
            if ("request".equals(name) || name.startsWith("h_") || "PASS".equals(name)) continue;
            for (String value : values) {
                this.addFormField(requestEnvelope, name, value);
            }
        }
    }

    private void addFormField(BIBusEnvelope requestEnvelope, String name, String value) {
        FormFieldVars formFieldVars = requestEnvelope.getBiBusHeader().getHdrSession().getFormFieldVars();
        if (name.contains("azzword")) {
            formFieldVars.addFormField(name.replace("azzword", "assword"), value, "encrypted");
        } else {
            formFieldVars.addFormField(name, value, null);
        }
    }

    private void copyHttpCookiesToCookieVars(BIBusEnvelope requestEnvelope, HttpServletRequest httpRequest) {
        Cookie[] cookies = CookieDecoder.getCookies(httpRequest);
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                String cookieName = cookie.getName();
                String cookieValue = cookie.getValue();
                cat.debug("received cookie: ", cookieName, "=", cookieValue, "\"");
                requestEnvelope.setCookie(cookieName, CookieQuoter.maybeUnquotedValue(cookieValue));
            }
        }
    }

    private boolean isWSDLRequest(HttpServletRequest httpRequest) {
        return WSDL_SERVICE.equalsIgnoreCase(httpRequest.getQueryString());
    }

    private void handleMagicParameters(BIBusEnvelope envelope, ParamBucket aParamBucket) {
        String conversationContextNodeID;
        String userPreferenceReloadValue;
        String camAction = aParamBucket.getValue("h_CAM_action");
        if (camAction != null) {
            envelope.setCAMaction(camAction);
        }
        if ((userPreferenceReloadValue = aParamBucket.getValue("h_userPreferenceReload")) != null) {
            envelope.setDispatcherTransport("userPreferenceReload", "true");
        }
        if ((conversationContextNodeID = aParamBucket.getValue("h_ccnid")) != null) {
            envelope.setConversationContextNodeID(conversationContextNodeID);
        }
    }

    private boolean verifySoapEncoding(String methodParams) {
        return SoapEncodingUtils.verifySoapEncoding(methodParams);
    }

    private void addMethodParamsToEnvironment(BIBusEnvelope requestEnvelope, String methodParams) {
        SoapEncodingUtils.addMethodParamsToEnvironment(methodParams, requestEnvelope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SOAPEnvelope createRequestEnvelope(HttpServletRequest httpRequest, MessageContext mc) throws Exception {
        if (this.isWSDLRequest(httpRequest)) {
            this.soapAction = WSDL_SERVICE;
            if (this.isGatewayRequest(httpRequest)) {
                mc.setProperty("checkCapabilities", Boolean.FALSE);
            }
            return this.createEnvelope(mc);
        }
        ParamBucket param_bucket = this.getParamBucket(httpRequest, mc);
        this.updatePerformanceIndicator(mc, param_bucket);
        mc.setProperty("request.method", httpRequest.getMethod());
        BIBusEnvelope requestEnvelope = this.createEnvelope(mc);
        this.copyHttpRequestParametersToEnvironmentVars(requestEnvelope, httpRequest, mc);
        this.copyUrlParametersToFormFieldVars(requestEnvelope, param_bucket);
        this.copyHttpCookiesToCookieVars(requestEnvelope, httpRequest);
        this.copyUrlParametersToDispatcherTransportVars(requestEnvelope, param_bucket);
        this.copyRoutingHeaderToEnvelope(requestEnvelope, httpRequest);
        this.handleMagicParameters(requestEnvelope, param_bucket);
        this.soapAction = param_bucket.getValue("b_action");
        if (this.soapAction != null) {
            cat.info("Received request for b_action ", this.soapAction);
            this.updateDcSoapActionFormVal(requestEnvelope);
        } else {
            this.soapAction = this.extractPathInfo(httpRequest, mc);
        }
        MethodParameterExtractor extractor = this.getParameterExtractor(httpRequest, mc);
        String methodParams = extractor.getMethodParams();
        String otherParams = extractor.getOtherParams();
        cat.info("Method Params are: ", methodParams);
        cat.info("Other Params are: ", otherParams);
        String request_string = param_bucket.getValue("request");
        if (request_string != null) {
            PooledSAXReader reader = null;
            try {
                reader = SAXReaderPool.getInstance().get();
                Document doc = reader.read(new StringReader(request_string));
                Element requestElement = doc.getRootElement();
                requestElement.detach();
                requestEnvelope.getBody().add(requestElement);
            }
            finally {
                reader.release();
            }
            if (this.isGatewayRequest(httpRequest)) {
                mc.setProperty("checkCapabilities", Boolean.TRUE);
            }
        } else if ("".equals(methodParams)) {
            if (this.isGatewayRequest(httpRequest)) {
                mc.setProperty("checkCapabilities", Boolean.FALSE);
            }
        } else if (this.soapAction != null && this.soapAction.startsWith("repository")) {
            this.prepareRepositoryRequest(mc, requestEnvelope, methodParams);
        } else if (this.verifySoapEncoding(methodParams)) {
            URLToSOAP url2soap = new URLToSOAP();
            try {
                ParameterList paramList = new ParameterList(methodParams);
                mc.setProperty("request.URL2SOAPParameterList", paramList);
                Document doc = url2soap.parse(paramList);
                if (url2soap.isSMEMOutput()) {
                    mc.setProperty("SMEMOutput", Boolean.TRUE);
                }
                String methodName = url2soap.getMethodName();
                this.soapAction = this.getSoapActionMapping(methodName);
                Element requestElement = doc.getRootElement();
                requestElement.detach();
                requestEnvelope.getBody().add(requestElement);
                this.copyPassportParameter(requestEnvelope, param_bucket);
                this.addMethodParamsToEnvironment(requestEnvelope, methodParams);
                if (this.isGatewayRequest(httpRequest)) {
                    mc.setProperty("checkCapabilities", Boolean.FALSE);
                }
                FormRequestProcessor.addValidator(requestEnvelope, mc);
                if (cat.isDebugEnabled()) {
                    this.logSOAPRequest(requestElement);
                }
            }
            catch (Url2SOAPParseException x) {
                cat.error(x.getMessage());
            }
        } else {
            Fault f = new Fault("FormRequestProcessor.InvalidUrlSoapEncoding");
            mc.setFault(f);
        }
        this.setWebContentRoot(httpRequest, requestEnvelope);
        return requestEnvelope;
    }

    private void prepareRepositoryRequest(MessageContext mc, BIBusEnvelope requestEnvelope, String methodParams) {
        mc.setProperty("checkCapabilities", Boolean.FALSE);
        ParameterParser paramParser = new ParameterParser();
        List parameterList = paramParser.parse(methodParams, '&');
        for (NameValuePair param : parameterList) {
            requestEnvelope.addFormField(param.getName(), param.getValue(), null);
        }
    }

    private void updatePerformanceIndicator(MessageContext mc, ParamBucket paramBucket) {
        PerformanceEventListener performanceIndicator = MCUtils.getPerformanceIndicator(mc);
        performanceIndicator.handleFormParameters(paramBucket);
    }

    private ParamBucket getParamBucket(HttpServletRequest httpRequest, MessageContext mc) {
        ParamBucket paramBucket = (ParamBucket)mc.getProperty("request.param_bucket");
        if (paramBucket == null) {
            paramBucket = this.parseParams(httpRequest, mc);
            mc.setProperty("request.param_bucket", paramBucket);
        }
        return paramBucket;
    }

    private ParamBucket parseParams(HttpServletRequest httpRequest, MessageContext mc) {
        ParamBucket paramBucket = new ParamBucket();
        try {
            MethodParameterExtractor extractor = this.getParameterExtractor(httpRequest, mc);
            paramBucket.parse(extractor.getOtherParams());
        }
        catch (Exception ex) {
            this.setFault(mc, ex);
        }
        return paramBucket;
    }

    private MethodParameterExtractor getParameterExtractor(HttpServletRequest httpRequest, MessageContext mc) throws Exception {
        MethodParameterExtractor extractor = (MethodParameterExtractor)mc.getProperty("request.param_extractor");
        if (extractor == null) {
            extractor = new MethodParameterExtractor(httpRequest);
            mc.setProperty("request.param_extractor", extractor);
        }
        return extractor;
    }

    private void setFault(MessageContext mc, Exception ex) {
        cat.debug("Cannot parse request because the request encoding is not supported", ex);
        Fault aFault = new Fault("FormRequestProcessor.unsupportedEncoding", ex);
        aFault.setClientFault(true);
        Object[] faultParams = new Object[]{ex.getMessage()};
        aFault.setMessageParameters(faultParams);
        mc.setFault(aFault);
    }

    private void copyUrlParametersToDispatcherTransportVars(BIBusEnvelope requestEnvelope, ParamBucket param_bucket) {
        String forceSOAPFault = param_bucket.getValue("forceSOAPFault");
        if ("true".equals(forceSOAPFault)) {
            requestEnvelope.setDispatcherTransport("html", "false");
        } else {
            requestEnvelope.setDispatcherTransport("html", "true");
        }
    }

    private String extractPathInfo(HttpServletRequest request, MessageContext mc) {
        String pathInfo = mc.getStrProperty(PATH_INFO);
        if (pathInfo != null) {
            int endpos;
            String newPathInfo;
            String originalScriptName = request.getHeader("Original-Script-Name");
            if (originalScriptName != null && !(newPathInfo = this.stripScriptName(originalScriptName, pathInfo)).equals(pathInfo)) {
                mc.setProperty(PATH_INFO, newPathInfo);
                pathInfo = newPathInfo;
            }
            int startpos = 0;
            if (pathInfo.startsWith("/")) {
                startpos = 1;
            }
            pathInfo = (endpos = pathInfo.indexOf("/", startpos)) == -1 ? pathInfo.substring(startpos) : pathInfo.substring(startpos, endpos);
        }
        cat.info("Received request with extra path info ", pathInfo);
        return pathInfo;
    }

    private String stripScriptName(String originalScriptName, String pathInfo) {
        int slashPos;
        int fromIndex = 0;
        while ((slashPos = originalScriptName.indexOf("/", fromIndex)) != -1) {
            if (pathInfo.startsWith(originalScriptName.substring(slashPos))) {
                return pathInfo.substring(originalScriptName.length() - slashPos);
            }
            fromIndex = slashPos + 1;
        }
        return pathInfo;
    }

    private void copyPassportParameter(BIBusEnvelope requestEnvelope, ParamBucket params) {
        String passValue = params.getValue("PASS");
        if (passValue == null || "".equals(passValue)) {
            return;
        }
        params.remove("PASS", passValue);
        requestEnvelope.setCookie("cam_passport", CookieQuoter.maybeUnquotedValue(passValue));
    }

    private void logSOAPRequest(Element e) {
        try {
            CharArrayWriter car = new CharArrayWriter();
            XMLWriter w = new XMLWriter((Writer)car, new OutputFormat("   ", true));
            w.write(e);
            w.close();
            cat.debug("form encoded SOAP msg: ", car);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void addValidator(BIBusEnvelope requestEnvelope, MessageContext messageContext) {
        String[] ifRangeValues;
        Element queryElement = requestEnvelope.getBody().element("query");
        if (queryElement == null) {
            return;
        }
        InternetHeaders headers = (InternetHeaders)messageContext.getProperty("request.headers");
        String[] ifNoneMatchValues = headers.getHeader("If-None-Match");
        String validatorValue = ifNoneMatchValues == null || ifNoneMatchValues.length < 1 || ifNoneMatchValues[0] == null ? ((ifRangeValues = headers.getHeader("If-Range")) == null || ifRangeValues.length < 1 || ifRangeValues[0] == null ? "?" : StringUtils.stripQuotes(ifRangeValues[0])) : StringUtils.stripQuotes(ifNoneMatchValues[0]);
        messageContext.setProperty("QueryValidator", validatorValue);
        queryElement.addElement("validator").setText(validatorValue);
    }

    @Override
    public PogoResponder createPogoResponder() {
        return new PogoSOAPAttachmentResponder();
    }

    @Override
    public String getSOAPAction(String newSOAPAction) {
        return this.soapAction;
    }

    @Override
    public boolean isXMLRequest() {
        return false;
    }

    protected void updateDcSoapActionFormVal(BIBusEnvelope busEnv) {
        if (this.soapAction.equals(DISPATCHER_CACHE_SOAP_ACTION) || this.soapAction.equals(REPORTSERVER_CACHE_SOAP_ACTION)) {
            busEnv.removeFormValue("b_action");
            busEnv.setFormField("b_action", this.getSoapActionMapping(this.soapAction));
        }
    }

    @Override
    protected String getAction(HttpServletRequest request, MessageContext mc) {
        ParamBucket paramBucket = this.getParamBucket(request, mc);
        String action = paramBucket.getValue("b_action");
        if (action == null) {
            action = this.extractPathInfo(request, mc);
        }
        return action;
    }

    protected String getSoapActionMapping(String action) {
        return methodToSoapActionMap.get(action);
    }

    static {
        methodToSoapActionMap = new HashMap<String, String>();
        C10_SERVICE_VERSION_SUFFIX = "/" + FormRequestProcessor.getCurrentServiceVersion() + "/";
        C10_SERVICE_VERSION = C10_SERVICE_VERSION_SUFFIX + "\"";
        CONTENT_MANAGER_SERVICE = "\"http://www.ibm.com/xmlns/prod/cognos/contentManagerService" + C10_SERVICE_VERSION;
        methodToSoapActionMap.put("add", CONTENT_MANAGER_SERVICE);
        methodToSoapActionMap.put("copy", CONTENT_MANAGER_SERVICE);
        methodToSoapActionMap.put("delete", CONTENT_MANAGER_SERVICE);
        methodToSoapActionMap.put("export", CONTENT_MANAGER_SERVICE);
        methodToSoapActionMap.put("getArchiveOptions", CONTENT_MANAGER_SERVICE);
        methodToSoapActionMap.put("getDeploymentOptions", CONTENT_MANAGER_SERVICE);
        methodToSoapActionMap.put("import", CONTENT_MANAGER_SERVICE);
        methodToSoapActionMap.put("listArchives", CONTENT_MANAGER_SERVICE);
        methodToSoapActionMap.put("move", CONTENT_MANAGER_SERVICE);
        methodToSoapActionMap.put("query", CONTENT_MANAGER_SERVICE);
        methodToSoapActionMap.put("update", CONTENT_MANAGER_SERVICE);
        methodToSoapActionMap.put("run", "xts.run");
        methodToSoapActionMap.put(DISPATCHER_CACHE_SOAP_ACTION, DISPATCHER_CACHE_SERVICE_SERVER_AFFINITY);
        methodToSoapActionMap.put(REPORTSERVER_CACHE_SOAP_ACTION, REPORTSERVER_CACHE_SERVICE_GET_AFFINITY);
        methodToSoapActionMap.put("back", REPORT_SERVICE_HIGH_AFFINITY);
        methodToSoapActionMap.put("cancel", REPORT_SERVICE_ABSOLUTE_AFFINITY);
        methodToSoapActionMap.put("collectParameterValues", REPORT_SERVICE);
        methodToSoapActionMap.put("editQuery", REPORT_SERVICE);
        methodToSoapActionMap.put("email", REPORT_SERVICE_HIGH_AFFINITY);
        methodToSoapActionMap.put("execute", REPORT_SERVICE);
        methodToSoapActionMap.put("firstPage", REPORT_SERVICE_HIGH_AFFINITY);
        methodToSoapActionMap.put("forward", REPORT_SERVICE_HIGH_AFFINITY);
        methodToSoapActionMap.put("getOutput", REPORT_SERVICE_ABSOLUTE_AFFINITY);
        methodToSoapActionMap.put("getParameters", REPORT_SERVICE);
        methodToSoapActionMap.put("lastPage", REPORT_SERVICE_HIGH_AFFINITY);
        methodToSoapActionMap.put("nextPage", REPORT_SERVICE_HIGH_AFFINITY);
        methodToSoapActionMap.put("previousPage", REPORT_SERVICE_HIGH_AFFINITY);
        methodToSoapActionMap.put("print", REPORT_SERVICE_HIGH_AFFINITY);
        methodToSoapActionMap.put("release", REPORT_SERVICE_ABSOLUTE_AFFINITY);
        methodToSoapActionMap.put("save", REPORT_SERVICE_HIGH_AFFINITY);
        methodToSoapActionMap.put("saveAs", REPORT_SERVICE_HIGH_AFFINITY);
        methodToSoapActionMap.put("validate", REPORT_SERVICE);
        methodToSoapActionMap.put("wait", REPORT_SERVICE_ABSOLUTE_AFFINITY);
        methodToSoapActionMap.put("release", REPORT_SERVICE_ABSOLUTE_AFFINITY);
        methodToSoapActionMap.put("editParameters", REPORT_SERVICE);
        methodToSoapActionMap.put("view", REPORT_SERVICE);
        methodToSoapActionMap.put("newQuery", REPORT_SERVICE);
        methodToSoapActionMap.put("queryStudio", REPORT_SERVICE);
        methodToSoapActionMap.put("powerPlayStudio", POWERPLAY_SERVICE);
        methodToSoapActionMap.put("notify", DISPATCHER_SERVICE);
        methodToSoapActionMap.put("ping", DISPATCHER_SERVICE);
        methodToSoapActionMap.put("startService", DISPATCHER_SERVICE);
        methodToSoapActionMap.put("stopService", DISPATCHER_SERVICE);
        methodToSoapActionMap.put("querySchedule", JOB_AND_SCHEDULE_MONITORING_SERVICE);
        methodToSoapActionMap.put("submit", JOB_AND_SCHEDULE_MONITORING_SERVICE);
        methodToSoapActionMap.put("updateSchedule", JOB_AND_SCHEDULE_MONITORING_SERVICE);
        methodToSoapActionMap.put("getMetadata", METADATA_SERVICE);
        methodToSoapActionMap.put("queryMetadata", METADATA_SERVICE);
        methodToSoapActionMap.put("updateMetadata", METADATA_SERVICE);
        methodToSoapActionMap.put("mapContentLocale", SYSTEM_SERVICE);
        methodToSoapActionMap.put("mapProductLocale", SYSTEM_SERVICE);
        methodToSoapActionMap.put("normalizeLocale", SYSTEM_SERVICE);
        methodToSoapActionMap.put("validateContentLocale", SYSTEM_SERVICE);
        methodToSoapActionMap.put("validateProductLocale", SYSTEM_SERVICE);
        methodToSoapActionMap = Collections.unmodifiableMap(methodToSoapActionMap);
    }
}

