/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.transport;

import com.cognos.pogo.handlers.debug.UtilHandlerBase;
import com.cognos.pogo.handlers.errorpage.ErrorPageGenerator;
import com.cognos.pogo.handlers.errorpage.ErrorPageInfo;
import com.cognos.pogo.impl.DispatcherStrings;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.pdk.SOAPEnvelope;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Locale;
import javax.mail.internet.InternetHeaders;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class GenerateErrorPage
extends UtilHandlerBase {
    static final Logger error_cat = Hierarchy.getDefaultHierarchy().getLoggerFor(GenerateErrorPage.class.getName());
    private static ErrorPageGenerator errorPageGenerator = new ErrorPageGenerator();
    private String m_message;
    private String errorDetail;
    private String basehref;
    private String contactAdmin = null;
    private String responseStatusMsg;
    private String responseStatusCode;

    public GenerateErrorPage(String message) {
        super(error_cat);
        this.m_message = message;
        this.responseStatusCode = Integer.toString(500);
        this.responseStatusMsg = "Internal Server Error";
    }

    @Override
    public void compose_impl(PogoEngine engine) throws PogoException {
    }

    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
        BIBusEnvelope env = (BIBusEnvelope)mc.getProperty("request.envelope");
        String s = env.getDispatcherTransportValue("html");
        Boolean do_html = Boolean.valueOf(s);
        this.setBaseHref(mc.getStrProperty("WEB_CONTENT_ROOT"));
        if (do_html.booleanValue()) {
            this.doHtmlResponse(mc);
        } else {
            this.doXmlResponse(mc);
        }
    }

    public void doHtmlResponse(MessageContext mc) {
        Locale locale = (Locale)mc.getProperty("locale");
        ErrorPageInfo epInfo = new ErrorPageInfo(this.m_message, locale);
        if (this.getErrorDetail() != null) {
            epInfo.addDetail(this.getErrorDetail());
        }
        if (this.basehref != null) {
            epInfo.setBasehref(this.basehref);
        }
        if (this.contactAdmin != null) {
            epInfo.setContactAdmin(DispatcherStrings.getInstance().getString(this.contactAdmin, locale));
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        errorPageGenerator.generateErrorPage(baos, epInfo);
        try {
            GenerateErrorPage.prepareResponse(mc, "text/html; charset=utf-8", baos.toByteArray());
        }
        catch (IOException x) {
            error_cat.warn("Error while generating error page.", (Throwable)x);
        }
    }

    private void doXmlResponse(MessageContext mc) {
        BIBusEnvelope requestEnvelope = (BIBusEnvelope)mc.getProperty("request.envelope");
        Fault fault = new Fault(this.m_message);
        fault.setMessageContext(mc);
        if (this.getErrorDetail() != null) {
            fault.addDetail(this.getErrorDetail());
        }
        SOAPEnvelope fault_env = fault.generateEnvelope(requestEnvelope);
        mc.setProperty("response.status_code", this.getResponseStatusCode());
        mc.setProperty("response.status_msg", this.getResponseStatusMsg());
        mc.setProperty("response.headers", new InternetHeaders());
        mc.setProperty("response.envelope", fault_env);
        try {
            mc.respond("response");
        }
        catch (IOException e) {
            error_cat.warn("Error while generating error page.", (Throwable)e);
        }
    }

    private String getErrorDetail() {
        return this.errorDetail;
    }

    public void setErrorDetail(String string) {
        this.errorDetail = string;
    }

    private String getResponseStatusCode() {
        return this.responseStatusCode;
    }

    public void setResponseStatusCode(String string) {
        this.responseStatusCode = string;
    }

    private String getResponseStatusMsg() {
        return this.responseStatusMsg;
    }

    public void setResponseStatusMsg(String string) {
        this.responseStatusMsg = string;
    }

    public void setBaseHref(String href) {
        this.basehref = href;
    }

    public void setContactAdmin(String contactAdmin) {
        this.contactAdmin = contactAdmin;
    }

    public static void setErrorPageGeneratorForTesting(ErrorPageGenerator errorPageGenerator) {
        GenerateErrorPage.errorPageGenerator = errorPageGenerator;
    }
}

