/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.transport;

import com.cognos.pogo.handlers.dispatchercache.MethodDispatcherCacheExtractorPathinfo;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.transport.MethodDispatcherCacheExtractorParams;
import com.cognos.pogo.transport.ParamBucket;
import com.cognos.pogo.util.CAMUtils;
import com.cognos.pogo.util.NameValuePair;
import com.cognos.pogo.util.PogoLogger;
import com.cognos.pogo.util.base64;

public abstract class MethodDispatcherCacheExtractor {
    private static final PogoLogger log = PogoLogger.getLogger();
    public static final String BS_FILE_NAME = "f";
    public static final String BS_HMAC_CSK_FILE = "k";
    public static final String BS_HMAC_CSK_USERID = "s";
    public static final String DISPATCHER_GUID = "did";
    public static final String REPORTSERVICE_PID = "rsid";
    protected String dc_web64filename = null;
    protected String dc_web64fileuserHmac = null;
    protected String dc_web64fileHmac = null;
    protected String dc_dispGUID = null;
    protected String dc_rsvpPID = null;
    protected CAMUtils cam;

    public static MethodDispatcherCacheExtractor getInstance(MessageContext mc, CAMUtils cam) throws Exception {
        String pathInfo = mc.getStrProperty("path_info");
        if (pathInfo != null) {
            return new MethodDispatcherCacheExtractorPathinfo(pathInfo, cam);
        }
        ParamBucket paramBucket = MethodDispatcherCacheExtractor.getParamBucket(mc);
        if (paramBucket != null) {
            return new MethodDispatcherCacheExtractorParams(paramBucket, cam);
        }
        return null;
    }

    protected static ParamBucket getParamBucket(MessageContext mc) {
        ParamBucket pb = (ParamBucket)mc.getProperty("request.param_bucket");
        if (pb == null) {
            pb = MethodDispatcherCacheExtractor.buildParamBucket(MethodDispatcherCacheExtractor.getRequestEnvelope(mc));
        }
        return pb;
    }

    protected static BIBusEnvelope getRequestEnvelope(MessageContext mc) {
        return (BIBusEnvelope)mc.getProperty("request.envelope");
    }

    static ParamBucket buildParamBucket(BIBusEnvelope envelope) {
        ParamBucket pb = new ParamBucket();
        try {
            pb.parse(envelope.getFormFieldValuesAsQueryString());
            return pb;
        }
        catch (Exception e) {
            log.debug("Failed to get paramBucket from envelope", e);
            return null;
        }
    }

    protected static String getValue(String key, NameValuePair formPair) {
        if (formPair.getName().equals(key)) {
            return formPair.getValue();
        }
        return null;
    }

    public String getWeb64FileName() {
        return this.dc_web64filename;
    }

    public String getWeb64HmacFileName() {
        return this.dc_web64fileHmac;
    }

    public String getWeb64HmacFileUserId() {
        return this.dc_web64fileuserHmac;
    }

    public String getDispatcherId() {
        return this.dc_dispGUID;
    }

    public String getRSVPId() {
        return this.dc_rsvpPID;
    }

    public String getFileName() throws Exception {
        return new String(base64.decode(1, this.dc_web64filename));
    }

    public byte[] getHmacFileName() {
        return base64.decode(1, this.dc_web64fileHmac);
    }

    public byte[] getHmacFileUserId() {
        return base64.decode(1, this.dc_web64fileuserHmac);
    }

    public static String getWeb64Filename(NameValuePair web64FormPair) {
        return MethodDispatcherCacheExtractor.getValue(BS_FILE_NAME, web64FormPair);
    }

    public static String getFilename(NameValuePair web64FormPair) {
        return new String(base64.decode(1, MethodDispatcherCacheExtractor.getWeb64Filename(web64FormPair)));
    }

    public static String getWeb64HmacFilename(NameValuePair web64FormPair) {
        return MethodDispatcherCacheExtractor.getValue(BS_HMAC_CSK_FILE, web64FormPair);
    }

    public static byte[] getHmacFilename(NameValuePair web64FormPair) {
        return base64.decode(1, MethodDispatcherCacheExtractor.getWeb64HmacFilename(web64FormPair));
    }

    public static String getWeb64HmacFileUser(NameValuePair web64FormPair) {
        return MethodDispatcherCacheExtractor.getValue(BS_HMAC_CSK_USERID, web64FormPair);
    }

    public static byte[] getHmacFileUser(NameValuePair web64FormPair) {
        return base64.decode(1, MethodDispatcherCacheExtractor.getWeb64HmacFileUser(web64FormPair));
    }

    public MethodDispatcherCacheExtractor(CAMUtils cam) {
        this.cam = cam;
    }

    public abstract boolean validateURLValues(CAMUtils var1, String var2) throws Exception;

    public static MethodDispatcherCacheExtractor getInstance(MessageContext mc) throws Exception {
        return MethodDispatcherCacheExtractor.getInstance(mc, null);
    }

    public String getPartName() {
        return null;
    }
}

