/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.transport;

import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.transport.MultipartFormRequestProcessor;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;

public class PostFormRequestProcessor
extends MultipartFormRequestProcessor {
    private static final String CONTENT_TYPE = "Content-Type: ";

    protected PostFormRequestProcessor(String[][] extraHeaders) {
        super(extraHeaders);
    }

    @Override
    protected void setInputInMessageContext(HttpServletRequest request, MessageContext mc) throws IOException {
        this.setRequestBodyInMessageContext(request, mc);
    }

    private void setRequestBodyInMessageContext(HttpServletRequest request, MessageContext mc) throws IOException {
        ServletInputStream inStream = request.getInputStream();
        mc.setProperty("request.body", inStream);
        String contentType = request.getContentType();
        this.createRequestAttachments(mc, (InputStream)inStream, contentType);
    }

    void createRequestAttachments(MessageContext mc, InputStream inStream, String contentType) {
        ArrayList<InternetHeaderInputStream> streamList = new ArrayList<InternetHeaderInputStream>();
        InternetHeaderInputStream stream = new InternetHeaderInputStream(contentType, inStream);
        streamList.add(stream);
        mc.setProperty("request.attachments", streamList.iterator());
    }

    private class InternetHeaderInputStream
    extends InputStream {
        private byte[] header;
        private final InputStream inStream;
        private int headerPos = 0;

        public InternetHeaderInputStream(String contentType, InputStream inStream) {
            this.inStream = inStream;
            this.header = this.getContentTypeHeader(contentType);
        }

        private byte[] getContentTypeHeader(String contentType) {
            try {
                return (PostFormRequestProcessor.CONTENT_TYPE + contentType + "\r\n\r\n").getBytes("utf-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return null;
            }
        }

        @Override
        public int read() throws IOException {
            if (this.headerPos < this.header.length) {
                return this.header[this.headerPos++];
            }
            return this.inStream.read();
        }

        @Override
        public int read(byte[] buffer, int off, int len) throws IOException {
            if (this.headerPos < this.header.length) {
                for (int i = 0; i < len && this.headerPos < this.header.length; ++i) {
                    buffer[i] = this.header[this.headerPos++];
                }
                return this.header.length;
            }
            return this.inStream.read(buffer, off, len);
        }
    }
}

