/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.transport;

import com.cognos.pogo.pdk.PogoEngineContext;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Set;
import javax.servlet.ServletContext;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class ServletEngineContext
implements PogoEngineContext {
    static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(ServletEngineContext.class.getName());
    private ServletContext context;
    private static boolean canUseResourcePaths = false;

    private static boolean canUseResourcePaths() {
        try {
            Class<?> servletContextClass = Class.forName("javax.servlet.ServletContext");
            servletContextClass.getMethod("getResourcePaths", String.class);
        }
        catch (ClassNotFoundException cnfe) {
            return false;
        }
        catch (NoSuchMethodException nsme) {
            return false;
        }
        return true;
    }

    public ServletEngineContext(ServletContext context) {
        this.context = context;
    }

    @Override
    public Object getAttribute(String s) {
        return this.context.getAttribute(s);
    }

    @Override
    public InputStream getResourceAsStream(String path) {
        return this.context.getResourceAsStream(path);
    }

    @Override
    public URL getResource(String path) throws MalformedURLException {
        return this.context.getResource(path);
    }

    @Override
    public void setAttribute(String name, Object object) {
        this.context.setAttribute(name, object);
    }

    @Override
    public Set<String> getResourcePaths(String path) throws NoSuchMethodException {
        if (!ServletEngineContext.isCanUseResourcePaths()) {
            throw new NoSuchMethodException("getResourcePaths() not supported.");
        }
        return this.context.getResourcePaths(path);
    }

    public static boolean isCanUseResourcePaths() {
        return canUseResourcePaths;
    }

    public static void forceCanUseResourcePathsForTesting(boolean value) {
        canUseResourcePaths = value;
    }

    static {
        canUseResourcePaths = ServletEngineContext.canUseResourcePaths();
    }
}

