/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.transport.url2soap;

import com.cognos.pogo.transport.url2soap.InputStruct;
import com.cognos.pogo.transport.url2soap.Url2SOAPParseException;
import com.cognos.pogo.util.URLEncoderDecoder;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.StringTokenizer;

public class ParameterList {
    private List<InputStruct> values = new ArrayList<InputStruct>();

    public ParameterList(String p_sArgs) throws Url2SOAPParseException {
        this.fillList(p_sArgs);
    }

    public void fillList(String sArgs) throws Url2SOAPParseException {
        this.values.clear();
        StringTokenizer st = new StringTokenizer(sArgs, "&");
        while (st.hasMoreTokens()) {
            String sToken = st.nextToken();
            if (sToken.length() == 0) continue;
            try {
                sToken = URLEncoderDecoder.decode(sToken, "UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                try {
                    sToken = URLDecoder.decode(sToken, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new Url2SOAPParseException(e.getMessage());
                }
            }
            InputStruct inputStruct = new InputStruct(sToken);
            this.values.add(inputStruct);
        }
    }

    public ListIterator<InputStruct> listIterator() {
        return this.values.listIterator();
    }
}

