/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.transport.url2soap;

import com.cognos.pogo.handlers.contentmanager.GzippedSearchPathExpander;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.cognos.pogo.transport.url2soap.InputStruct;
import com.cognos.pogo.transport.url2soap.ParameterList;
import com.cognos.pogo.transport.url2soap.Url2SOAPParseException;
import com.cognos.pogo.util.PogoLogger;
import java.util.List;
import java.util.ListIterator;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class URLToSOAP {
    private static final PogoLogger cat = PogoLogger.getLogger();
    public static final String sARRAY_ELEMENT_NAME = "item";
    public static final String sXSI_TYPE = "xsi:type";
    public static final String sBIBUS_PREFIX = "bus";
    public static final String sNULL = "NULL";
    public static final String sSTART_METHOD = "SM";
    public static final String sEND_METHOD = "EM";
    public static final String sSTART_STRUCTURE = "SS";
    public static final String sEND_STRUCTURE = "ES";
    public static final String sSTART_ARRAY = "SA";
    public static final String sEND_ARRAY = "EA";
    public static final String sDEFAULT_NAMESPACE = "http://developer.cognos.com/schemas/bibus/3/";
    public static final String sXSI_NAMESPACE = "http://www.w3.org/2001/XMLSchema-instance";
    public static final String sWEB_COMPRESSED = "webcompress";
    public static final String sDOWNLOAD = "download";
    public static final String sSEARCH = "search";
    private static final Namespace NS_BUS = Namespace.get((String)"bus", (String)"http://developer.cognos.com/schemas/bibus/3/");
    private Namespace oBIBusNamespace = DocumentHelper.createNamespace((String)"bus", (String)"http://developer.cognos.com/schemas/bibus/3/");
    private ListIterator<InputStruct> paramIterator;
    private String methodName;
    private boolean SMEMOutput;
    private boolean webCompress = false;
    private boolean download = false;
    public static final QName BUS_TYPE = DocumentHelper.createQName((String)"type", (Namespace)NS_BUS);

    public String getMethodName() {
        return this.methodName;
    }

    public Document parse(ParameterList paramList) throws Url2SOAPParseException {
        this.webCompress = this.checkIfSearchPathIsWeb64Encoded(paramList);
        this.paramIterator = paramList.listIterator();
        Document oDocument = DocumentHelper.createDocument();
        InputStruct oInputStruct = this.paramIterator.next();
        this.methodName = oInputStruct.getValue();
        Element oRoot = DocumentHelper.createElement((QName)DocumentHelper.createQName((String)this.methodName, (Namespace)this.oBIBusNamespace));
        oRoot.addAttribute(SOAPEnvelope.XSI_TYPE, sXSI_NAMESPACE);
        oDocument.add(oRoot);
        while (this.paramIterator.hasNext() && !(oInputStruct = this.paramIterator.next()).getName().equals(sEND_METHOD)) {
            if (oInputStruct.getName().equals(sSTART_ARRAY)) {
                oRoot.add(this.processArray(oInputStruct));
                continue;
            }
            if (oInputStruct.getName().equals(sSTART_STRUCTURE)) {
                oRoot.add(this.processStructure(oInputStruct));
                continue;
            }
            if (oInputStruct.getName().equals(sSEARCH)) {
                if ("query".equals(this.methodName)) {
                    this.checkForSMEMOutput(oInputStruct.getValue());
                }
                if (this.webCompress) {
                    oInputStruct.setValue(this.decodeDecompressSearchPath(oInputStruct.getValue()));
                }
                oRoot.add(this.addNode(oInputStruct));
                continue;
            }
            if (oInputStruct.getName().equals(sWEB_COMPRESSED)) continue;
            if (oInputStruct.getName().equals(sDOWNLOAD)) {
                this.download = true;
                continue;
            }
            oRoot.add(this.addNode(oInputStruct));
        }
        return oDocument;
    }

    private String decodeDecompressSearchPath(String zippedExpression) {
        GzippedSearchPathExpander pathExpander = new GzippedSearchPathExpander(zippedExpression);
        try {
            return pathExpander.getSearchPath();
        }
        catch (Exception e) {
            cat.error("Failed to Web64 decode and decompress search item: " + zippedExpression, e);
            return zippedExpression;
        }
    }

    private boolean checkIfSearchPathIsWeb64Encoded(ParameterList paramList) {
        ListIterator<InputStruct> aParamIterator = paramList.listIterator();
        while (aParamIterator.hasNext()) {
            InputStruct oInputStruct = aParamIterator.next();
            if (!oInputStruct.getName().equals(sWEB_COMPRESSED)) continue;
            return Boolean.parseBoolean(oInputStruct.getValue());
        }
        return false;
    }

    private Element processArray(InputStruct p_oInputStruct) {
        InputStruct oInputStruct = p_oInputStruct;
        Element oElement = DocumentHelper.createElement((String)oInputStruct.getValue());
        oElement.addAttribute(SOAPEnvelope.SOAP_ENC_ARRAYTYPE, this.fixNamespaceHack(oInputStruct.getType()));
        oElement.addAttribute(SOAPEnvelope.XSI_TYPE, "SOAP-ENC:Array");
        oInputStruct = this.paramIterator.next();
        while (this.paramIterator.hasNext() && !oInputStruct.getName().equals(sEND_ARRAY)) {
            if (oInputStruct.getName().equals(sSTART_STRUCTURE)) {
                oElement.add(this.processStructure(oInputStruct));
            } else if (oInputStruct.getName().equals(sSTART_ARRAY)) {
                oElement.add(this.processArray(oInputStruct));
            } else {
                oElement.add(this.processArrayItem(oInputStruct));
            }
            oInputStruct = this.paramIterator.next();
        }
        return oElement;
    }

    private String fixNamespaceHack(String dataType) {
        if (dataType.startsWith("int") || dataType.startsWith("string") || dataType.startsWith("boolean")) {
            return "xsd:" + dataType;
        }
        return "bus:" + dataType;
    }

    private Element processArrayItem(InputStruct p_oInputStruct) {
        InputStruct oInputStruct = p_oInputStruct;
        Element oElement = DocumentHelper.createElement((String)sARRAY_ELEMENT_NAME);
        String type = oInputStruct.getType();
        if (type != null && !"".equals(type)) {
            oElement.addAttribute(SOAPEnvelope.XSI_TYPE, this.fixNamespaceHack(type));
        }
        oElement.addText(oInputStruct.getValue());
        return oElement;
    }

    private Element processStructure(InputStruct p_oInputStruct) {
        InputStruct oInputStruct = p_oInputStruct;
        Element oElement = DocumentHelper.createElement((QName)DocumentHelper.createQName((String)oInputStruct.getValue()));
        String type = oInputStruct.getType();
        if (type != null && !"".equals(type)) {
            oElement.addAttribute(SOAPEnvelope.XSI_TYPE, this.fixNamespaceHack(type));
        }
        oInputStruct = this.paramIterator.next();
        while (this.paramIterator.hasNext() && !oInputStruct.getName().equals(sEND_STRUCTURE)) {
            if (oInputStruct.getName().equals(sSTART_STRUCTURE)) {
                oElement.add(this.processStructure(oInputStruct));
            } else if (oInputStruct.getName().equals(sSTART_ARRAY)) {
                oElement.add(this.processArray(oInputStruct));
            } else if (oInputStruct.getName().equals(sNULL)) {
                List attributeList = oElement.attributes();
                attributeList.clear();
                oElement.addAttribute(SOAPEnvelope.XSI_NIL, "true");
            } else {
                oElement.add(this.addNode(oInputStruct));
            }
            oInputStruct = this.paramIterator.next();
        }
        return oElement;
    }

    private Element addNode(InputStruct p_oInputStruct) {
        InputStruct oInputStruct = p_oInputStruct;
        String structName = oInputStruct.getName();
        Element oElement = DocumentHelper.createElement((String)structName);
        oElement.addText(oInputStruct.getValue());
        return oElement;
    }

    private void checkForSMEMOutput(String searchPath) {
        if (searchPath.startsWith("defaultOutput") || searchPath.startsWith("URLID")) {
            this.SMEMOutput = true;
            return;
        }
        int lastSlashPosition = searchPath.lastIndexOf(47);
        this.SMEMOutput = searchPath.startsWith("output", lastSlashPosition + 1);
    }

    public boolean isSMEMOutput() {
        return this.SMEMOutput;
    }

    public boolean isDownload() {
        return this.download;
    }
}

