/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.util;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.util.PogoLogger;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.log.Priority;

public class AdvancedSettingsParameter {
    private static final PogoLogger log = PogoLogger.getLogger();
    private final String prefix;
    private final String suffix;
    private Map<String, String> advancedSettings = Collections.synchronizedMap(new HashMap());

    public AdvancedSettingsParameter(String prefix, String suffix) {
        this.prefix = prefix;
        this.suffix = suffix;
    }

    String getValue(String parameterName, String defaultValue) {
        String name = this.prefix + parameterName + this.suffix;
        String value = this.advancedSettings.get(name);
        log.debug(name, Character.valueOf('='), value, " (default: ", defaultValue, Character.valueOf(')'));
        return value != null ? value : defaultValue;
    }

    public void updateConfiguration(Configuration configuration) {
        try {
            Map<String, String> parameters = this.extractParameters(configuration);
            this.updateAdvancedSettings(parameters);
        }
        catch (Exception e) {
            log.warn("Caught exception while reading configurarion parameters: ", e);
        }
    }

    private Map<String, String> extractParameters(Configuration configuration) throws CCLConfigurationException {
        HashMap<String, String> extractedParameters = new HashMap<String, String>();
        Collection<String> parameterNames = this.getParameterNames(configuration);
        for (String parameterName : parameterNames) {
            if (!this.isAdvancedSettingsParameter(parameterName)) continue;
            extractedParameters.put(parameterName, configuration.getValue(parameterName));
        }
        return extractedParameters;
    }

    private Collection<String> getParameterNames(Configuration configuration) throws CCLConfigurationException {
        return configuration.getICCLConfiguration().getParameterNames();
    }

    private boolean isAdvancedSettingsParameter(String parameterName) {
        return parameterName != null && parameterName.startsWith(this.prefix) && parameterName.endsWith(this.suffix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAdvancedSettings(Map<String, String> parameters) {
        Map<String, String> map = this.advancedSettings;
        synchronized (map) {
            this.advancedSettings.clear();
            this.advancedSettings.putAll(parameters);
        }
    }

    public static void setLogPriority(Priority priority) {
        log.setPriority(priority);
    }
}

