/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.util;

import com.cognos.pogo.util.URLEncoderDecoder;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class CROneCookie {
    private static final String COOKIE_DELIMITER = "&";
    public static final String FORMAT_PROPERTY = "format";
    public static final String PRODUCTLOCALE_PROPERTY = "productLocale";
    public static final String CONTENTLOCALE_PROPERTY = "contentLocale";
    public static final String TIMEZONE_PROPERTY = "timeZoneID";
    public static final String COOKIE_NAME = "CRN";
    public static final String OLD_COOKIE_NAME = "CR1";
    private Map<String, String> preferences = new HashMap<String, String>();

    public CROneCookie() {
    }

    public CROneCookie(String cookieString) throws IllegalArgumentException {
        this.parseCookieString(cookieString);
    }

    public void addPreference(String name, String value) {
        this.preferences.put(name, value);
    }

    public String getCookieString() {
        StringBuffer strBuf = new StringBuffer();
        for (Map.Entry<String, String> entry : this.preferences.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            strBuf.append(this.escape(key)).append("=").append(this.escape(value)).append(COOKIE_DELIMITER);
        }
        return this.escape(strBuf.toString());
    }

    public Map<String, String> getPreferences() {
        return this.preferences;
    }

    public boolean hasPreferences() {
        return !this.preferences.isEmpty();
    }

    private void parseCookieString(String cookieString) throws IllegalArgumentException {
        StringTokenizer strTok = new StringTokenizer(this.unescape(cookieString), COOKIE_DELIMITER, false);
        while (strTok.hasMoreTokens()) {
            this.processNameValuePair(strTok.nextToken());
        }
    }

    private void processNameValuePair(String nameValuePair) throws IllegalArgumentException {
        int pos = nameValuePair.indexOf("=");
        if (pos < 0) {
            throw new IllegalArgumentException();
        }
        String name = nameValuePair.substring(0, pos);
        String value = nameValuePair.substring(++pos, nameValuePair.length());
        this.preferences.put(this.unescape(name), this.unescape(value));
    }

    private String escape(String aString) {
        try {
            return URLEncoderDecoder.encode(aString, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            return aString;
        }
    }

    private String unescape(String aString) throws IllegalArgumentException {
        try {
            return URLEncoderDecoder.decode(aString, "UTF-8");
        }
        catch (Exception exception) {
            throw new IllegalArgumentException();
        }
    }
}

