/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.util;

import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.util.AdvancedSettingsParameter;
import com.cognos.pogo.util.PogoLogger;
import com.cognos.pogo.util.PropertyParameter;
import org.apache.log.Priority;

public class ConfigurationParameter {
    private static final PogoLogger log = PogoLogger.getLogger();
    private static final String defaultParameterValue = "0";
    private final String namePrefix;
    private final String nameSuffix;
    private final AdvancedSettingsParameter advancedSettingsParameter;
    private final PropertyParameter propertyParameter;
    private String defaultParameterName = "default";
    private String defaultValue = "0";

    public ConfigurationParameter(String namePrefix, String nameSuffix) {
        this(namePrefix, nameSuffix, new AdvancedSettingsParameter(namePrefix, nameSuffix), new PropertyParameter(nameSuffix));
    }

    protected ConfigurationParameter(String namePrefix, String nameSuffix, AdvancedSettingsParameter advancedSettingsParameter, PropertyParameter propertyParameter) {
        this.namePrefix = namePrefix;
        this.nameSuffix = nameSuffix;
        this.advancedSettingsParameter = advancedSettingsParameter;
        this.propertyParameter = propertyParameter;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getValue(String parameterName) {
        return this.getValue(parameterName, this.getDefaultValue());
    }

    public String getValue(String parameterName, String defaultValue) {
        String propertyValue = this.propertyParameter.getValue(parameterName, defaultValue);
        String parameterValue = this.advancedSettingsParameter.getValue(parameterName, propertyValue);
        this.logParameterMessage(parameterName, parameterValue);
        return parameterValue;
    }

    private void logParameterMessage(String name, String value) {
        log.debug("Parameter [", this.namePrefix, name, this.nameSuffix, "] = [", value, "]");
    }

    private String getDefaultValue() {
        return this.isDefaultParameterEnabled() ? this.getValue(this.defaultParameterName, this.defaultValue) : this.defaultValue;
    }

    private boolean isDefaultParameterEnabled() {
        return this.defaultParameterName != null;
    }

    public void disableDefaultParameter() {
        this.defaultParameterName = null;
    }

    public double getValueAsDouble(String parameterName) {
        return this.convertToDouble(parameterName, this.getValue(parameterName), this.getDefaultValue());
    }

    private double convertToDouble(String name, String value, String defaultValue) {
        try {
            return Double.parseDouble(value);
        }
        catch (Exception e) {
            this.logParameterWarning(name, value, defaultValue);
            return this.parseDoubleDefault(name, defaultValue, this.defaultValue);
        }
    }

    private double parseDoubleDefault(String name, String value, String defaultValue) {
        try {
            return Double.parseDouble(value);
        }
        catch (Exception e) {
            this.logParameterWarning(name, value, defaultValue);
            return this.parseDoubleDefault(name, defaultValue, defaultParameterValue);
        }
    }

    private void logParameterWarning(String name, String value, String defaultValue) {
        log.warn("Invalid parameter: [", this.namePrefix, name, this.nameSuffix, "] = [", value, "]. Using default value = [", defaultValue, "]");
    }

    public void updateConfiguration(Configuration configuration) {
        this.advancedSettingsParameter.updateConfiguration(configuration);
    }

    public static void setLogPriority(Priority priority) {
        log.setPriority(priority);
    }
}

