/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.util;

import com.cognos.pogo.util.Check;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class InputStreamAvailableCounter {
    private InputStreamAvailableCounter() {
    }

    private static byte[] doubleSize(byte[] oldArray) {
        byte[] newArray = new byte[2 * oldArray.length];
        System.arraycopy(oldArray, 0, newArray, 0, oldArray.length);
        return newArray;
    }

    public static InputStream countAvailable(InputStream inStream) throws IOException {
        Check.notNull(inStream);
        byte[] data = new byte[2048];
        int bytesRead = 0;
        int aByte = inStream.read();
        while (aByte != -1) {
            if (bytesRead == data.length) {
                data = InputStreamAvailableCounter.doubleSize(data);
            }
            data[bytesRead] = (byte)aByte;
            ++bytesRead;
            aByte = inStream.read();
        }
        return new ByteArrayInputStream(data, 0, bytesRead);
    }
}

