/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HeaderElement;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.NameValuePair;

public class MyCookie
extends Cookie {
    private static final long serialVersionUID = 1L;
    private static final DateFormat[] myExpiryFormats = new DateFormat[4];

    public MyCookie(String domain, String name, String value) {
        super(domain, name, value);
    }

    public MyCookie(String domain, String name, String value, String path, Date expires, boolean secure) {
        super(domain, name, value, path, expires, secure);
    }

    public MyCookie(String domain, String name, String value, String path, int maxAge, boolean secure) {
        super(domain, name, value, path, maxAge, secure);
    }

    public static Cookie[] parse(Header setCookie) throws HttpException {
        return MyCookie.parse("", 80, "", false, setCookie);
    }

    public static Cookie[] parse(String domain, int port, String path, boolean secure, Header setCookie) throws HttpException {
        HeaderElement[] headerElements = HeaderElement.parseElements((String)setCookie.getValue());
        Cookie[] cookies = new Cookie[headerElements.length];
        int index = 0;
        for (int i = 0; i < headerElements.length; ++i) {
            MyCookie cookie = new MyCookie(domain, headerElements[i].getName(), headerElements[i].getValue());
            NameValuePair[] parameters = headerElements[i].getParameters();
            if (parameters != null) {
                for (int j = 0; j < parameters.length; ++j) {
                    String name = parameters[j].getName().toLowerCase();
                    if ((name.equals("version") || name.equals("max-age") || name.equals("domain") || name.equals("path") || name.equals("comment") || name.equals("expires")) && parameters[j].getValue() == null) {
                        throw new HttpException("Bad Set-Cookie header: " + setCookie.getValue() + "\nMissing value for " + parameters[j].getName() + " attribute in cookie '" + headerElements[i].getName() + "'");
                    }
                    if (name.equals("version")) {
                        try {
                            cookie.setVersion(Integer.parseInt(parameters[j].getValue()));
                            continue;
                        }
                        catch (NumberFormatException nfe) {
                            throw new HttpException("Bad Set-Cookie header: " + setCookie.getValue() + "\nVersion '" + parameters[j].getValue() + "' not a number");
                        }
                    }
                    if (name.equals("path")) {
                        cookie.setPath(parameters[j].getValue());
                        continue;
                    }
                    if (name.equals("domain")) {
                        String d = parameters[j].getValue().toLowerCase();
                        if (d.charAt(0) != '.' && !d.equals(domain)) {
                            cookie.setDomain("." + d);
                            continue;
                        }
                        cookie.setDomain(d);
                        continue;
                    }
                    if (name.equals("max-age")) {
                        int age;
                        try {
                            age = Integer.parseInt(parameters[j].getValue());
                        }
                        catch (NumberFormatException e) {
                            throw new HttpException("Bad Set-Cookie header: " + setCookie.getValue() + " Max-Age '" + parameters[j].getValue() + "' not a number");
                        }
                        cookie.setExpiryDate(new Date(System.currentTimeMillis() + (long)age * 1000L));
                        continue;
                    }
                    if (name.equals("secure")) {
                        cookie.setSecure(true);
                        continue;
                    }
                    if (name.equals("comment")) {
                        cookie.setComment(parameters[j].getValue());
                        continue;
                    }
                    if (!name.equals("expires")) continue;
                    boolean set = false;
                    String expiryDate = parameters[j].getValue();
                    for (int k = 0; k < myExpiryFormats.length; ++k) {
                        try {
                            Date date = myExpiryFormats[k].parse(expiryDate);
                            cookie.setExpiryDate(date);
                            set = true;
                            break;
                        }
                        catch (ParseException parseException) {
                            continue;
                        }
                    }
                    if (set) continue;
                    throw new HttpException("Unable to parse expiration date parameter: \"" + expiryDate + "\"");
                }
            }
            if (cookie.getSecure() && !secure) {
                throw new HttpException("Bad Set-Cookie header: " + setCookie.getValue() + " Secure cookie sent over a non-secure channel.");
            }
            if (null == cookie.getPath() && null != path) {
                if (!path.endsWith("/")) {
                    int x = path.lastIndexOf("/");
                    if (0 < x) {
                        cookie.setPath(path.substring(0, x));
                    } else {
                        cookie.setPath("/");
                    }
                } else {
                    cookie.setPath(path);
                }
            }
            cookies[index++] = cookie;
        }
        return cookies;
    }

    static {
        MyCookie.myExpiryFormats[0] = new SimpleDateFormat("EEE, dd-MMM-yy HH:mm:ss z", Locale.US);
        MyCookie.myExpiryFormats[1] = new SimpleDateFormat("EEE, dd-MMM-yyyy HH:mm:ss z", Locale.US);
        MyCookie.myExpiryFormats[2] = new SimpleDateFormat("EEE dd-MMM-yy HH:mm:ss z", Locale.US);
        MyCookie.myExpiryFormats[3] = new SimpleDateFormat("EEE dd-MMM-yyyy HH:mm:ss z", Locale.US);
    }
}

