/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.util;

public class StackTrace {
    private static final StackTraceElement[] EMPTY_STACK_TRACE = new StackTraceElement[0];
    private static final int NOT_FOUND = -1;

    public StackTraceElement getCaller() {
        StackTraceElement[] stackTrace = this.getStackTrace();
        int currentMethod = this.findElement(stackTrace, "StackTrace.java", "getCaller");
        return currentMethod == -1 ? null : this.getCaller(stackTrace, currentMethod);
    }

    protected StackTraceElement[] getStackTrace() {
        try {
            return Thread.currentThread().getStackTrace();
        }
        catch (Exception e) {
            return EMPTY_STACK_TRACE;
        }
    }

    private int findElement(StackTraceElement[] stackTrace, String fileName, String methodName) {
        if (stackTrace != null) {
            for (int i = 0; i < stackTrace.length; ++i) {
                if (!this.stackTraceElementEquals(stackTrace[i], fileName, methodName)) continue;
                return i;
            }
        }
        return -1;
    }

    private boolean stackTraceElementEquals(StackTraceElement element, String fileName, String methodName) {
        if (element != null) {
            String fname = element.getFileName();
            String mname = element.getMethodName();
            if (fname != null && mname != null) {
                return fname.equalsIgnoreCase(fileName) && mname.equalsIgnoreCase(methodName);
            }
        }
        return false;
    }

    private StackTraceElement getCaller(StackTraceElement[] stackTrace, int currentMethod) {
        int methodCaller = currentMethod + 1;
        int callersCaller = methodCaller + 1;
        return this.getElement(stackTrace, callersCaller);
    }

    private StackTraceElement getElement(StackTraceElement[] stackTrace, int index) {
        return index < stackTrace.length ? stackTrace[index] : null;
    }
}

