/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.util.threads;

import com.cognos.pogo.util.PogoLogger;

public class SafeThread
extends Thread {
    private static PogoLogger log = PogoLogger.getLogger();
    private Runnable runnable;

    public SafeThread() {
    }

    public SafeThread(Runnable runnable, String threadName) {
        super(runnable, threadName);
        this.runnable = runnable;
    }

    public SafeThread(Runnable runnable) {
        super(runnable);
        this.runnable = runnable;
    }

    public SafeThread(String threadName) {
        super(threadName);
    }

    public SafeThread(ThreadGroup group, Runnable runnable, String threadName, long stack) {
        super(group, runnable, threadName, stack);
        this.runnable = runnable;
    }

    public SafeThread(ThreadGroup group, Runnable runnable, String threadName) {
        super(group, runnable, threadName);
        this.runnable = runnable;
    }

    public SafeThread(ThreadGroup group, Runnable runnable) {
        super(group, runnable);
        this.runnable = runnable;
    }

    public SafeThread(ThreadGroup group, String threadName) {
        super(group, threadName);
    }

    @Override
    public final void run() {
        try {
            this.safeRun();
        }
        catch (Exception e) {
            log.warn("Thread " + Thread.currentThread().getName() + " has died by throwing the following (uncaught) exception: ", e);
        }
    }

    protected void safeRun() {
        if (this.runnable != null) {
            this.runnable.run();
        }
    }

    public static void setLoggerForTesting(PogoLogger log) {
        SafeThread.log = log;
    }
}

