/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.admin.core.resources;

import com.ibm.bi.admin.commons.utilities.EndpointProperty;
import com.ibm.bi.admin.core.MessageKeys;
import com.ibm.bi.admin.core.resources.ContentManager;
import com.ibm.bi.admin.core.resources.Responder;
import com.ibm.bi.admin.core.resources.SaCamService;
import com.ibm.bi.admin.core.resources.UserCapabilities;
import com.ibm.bi.admin.core.utils.Identity;
import com.ibm.bi.admin.core.utils.QueryParams;
import com.ibm.bi.admin.crypto.utilities.TrustedContext;
import com.ibm.bi.json.DefaultJsonFactory;
import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonObject;
import com.ibm.bi.platform.commons.messages.Message;
import com.ibm.bi.platform.commons.shared.BIResource;
import com.ibm.bi.rest.RESTClient;
import com.ibm.bi.rest.RESTClientFactory;
import com.ibm.bi.soap.schema.Type;
import com.ibm.bi.soap.services.BiBus;
import com.ibm.bi.soap.services.SoapContext;
import com.ibm.bi.soap.services.SoapException;
import com.ibm.bi.soap.services.SoapTransportFactory;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseResource
extends BIResource {
    protected static final Logger logger = LoggerFactory.getLogger(BaseResource.class);
    private static final String ADM_TENANT_REST = "ADM-TENANT-REST";
    protected Request request;
    protected BiBus biBus;
    protected BiBus trustedBiBus;
    protected ContentManager cm;
    protected SaCamService saCam;
    protected Responder responder;
    protected QueryParams queryParams;
    protected UserCapabilities userCapabilities = null;
    private Identity identity;
    private static final JsonObject permissionsMap = BaseResource.parseJson("{r: {name:read, access:grant},w: {name:write, access:grant},x: {name:execute, access:grant},t: {name:traverse, access:grant},p: {name:setPolicy, access:grant},R: {name:read, access:deny},W: {name:write, access:deny},X: {name:execute, access:deny},T: {name:traverse, access:deny},P: {name:setPolicy, access:deny}}");

    private static JsonObject parseJson(String s) {
        try {
            return JsonObject.parseString((String)s, (boolean)false);
        }
        catch (IOException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public BaseResource(HttpServletRequest servletRequest, Request request) throws Exception {
        this.httpServletRequest = servletRequest;
        this.request = request;
        SoapContext soapContext = new SoapContext(servletRequest);
        this.biBus = new BiBus(SoapTransportFactory.getInstance().create(), soapContext, this.buildBaseURL());
        this.cm = new ContentManager(servletRequest, this.biBus);
        this.saCam = new SaCamService(servletRequest, this.biBus);
        this.responder = new Responder(soapContext, request);
        this.queryParams = new QueryParams(this.httpServletRequest);
    }

    public BaseResource() {
    }

    public void updateBaseResource(HttpServletRequest servletRequest, Request request) throws Exception {
        this.httpServletRequest = servletRequest;
        this.request = request;
        SoapContext soapContext = new SoapContext(servletRequest);
        this.biBus = new BiBus(SoapTransportFactory.getInstance().create(), soapContext, this.buildBaseURL());
        this.cm = new ContentManager(servletRequest, this.biBus);
        this.saCam = new SaCamService(servletRequest, this.biBus);
        this.responder = new Responder(soapContext, request);
        this.queryParams = new QueryParams(this.httpServletRequest);
    }

    protected BiBus getTrustedBiBus(String service) throws Exception {
        if (this.trustedBiBus == null) {
            TrustedContext soapContext = new TrustedContext(this.httpServletRequest, service);
            this.trustedBiBus = new BiBus(SoapTransportFactory.getInstance().create(), (SoapContext)soapContext, this.buildBaseURL());
        }
        return this.trustedBiBus;
    }

    protected ContentManager getTrustedCM() throws Exception {
        return new ContentManager(this.httpServletRequest, this.getTrustedBiBus(null));
    }

    protected ContentManager getTrustedCMForTenantOperations() throws Exception {
        return new ContentManager(this.httpServletRequest, this.getTrustedBiBus(ADM_TENANT_REST));
    }

    public Type getBiBusType(String name) {
        return BiBus.getTypeLibrary().getSchemaByName("bus").getType(name);
    }

    public JsonObject buildDeleteOptions() {
        JsonObject result = new JsonObject();
        result.put("force", (Object)this.queryParams.getBoolean("force", true));
        result.put("recursive", (Object)this.queryParams.getBoolean("recursive", true));
        return result;
    }

    public JsonObject buildAddOptions(String updateAction) {
        JsonObject options = null;
        if (updateAction != null) {
            options = new JsonObject();
            options.put("updateAction", (Object)updateAction);
        }
        return options;
    }

    protected Identity getIdentity(EndpointProperty endPoint) throws Exception {
        if (this.identity == null) {
            this.identity = new Identity(this.cm, endPoint);
        }
        return this.identity;
    }

    protected JsonObject createPolicy(String object, String permissions) {
        JsonObject result = new JsonObject();
        JsonObject so = new JsonObject();
        so.put("searchPath", (Object)object);
        so.put("type", (Object)"baseClass");
        result.put("securityObject", (Object)so);
        JsonArray access = new JsonArray();
        for (int i = 0; i < permissions.length(); ++i) {
            access.add(permissionsMap.get(permissions.substring(i, i + 1)));
        }
        result.put("permissions", (Object)access);
        return result;
    }

    protected boolean getBooleanQueryParam(String name) {
        return Boolean.parseBoolean(this.httpServletRequest.getParameter(name));
    }

    protected String[] getArrayQueryParam(String name) {
        String s = this.httpServletRequest.getParameter(name);
        if (s != null) {
            return s.split(",");
        }
        return null;
    }

    protected Map<String, Integer> calOptions(int objectsFrom, int objectsNumber) {
        Map options = DefaultJsonFactory.instance.createObject();
        options.put("maxObjects", objectsNumber);
        options.put("skipObjects", objectsFrom);
        return options;
    }

    public Response buildFailedResponseMsg(Response.Status respStatus, String errMsg) {
        JsonObject message = new JsonObject();
        message.put("errorMessage", (Object)errMsg);
        logger.error(message.toString());
        return Response.status((Response.Status)respStatus).entity((Object)message).build();
    }

    public Response handleKnownCMErrors(SoapException se) {
        Response response = null;
        String errorcode = se.getErrorCode();
        if (errorcode != null) {
            switch (errorcode) {
                case "cmNoWrite": {
                    response = this.buildFailedResponseMsg(Response.Status.FORBIDDEN, se.getErrorCode());
                    break;
                }
                case "cmDuplicateName": {
                    response = this.buildFailedResponseMsg(Response.Status.CONFLICT, se.getErrorCode());
                    break;
                }
                case "cmBadProp": 
                case "cmInvalidSearchPath": {
                    response = this.buildFailedResponseMsg(Response.Status.BAD_REQUEST, se.getErrorCode());
                    break;
                }
                default: {
                    response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
                }
            }
        }
        return response;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getTenantId() throws Exception {
        try (RESTClient client = this.getCARESTClient();){
            JsonObject resp = client.getResourceAsJson("/bi/v1/me", "application/json");
            if (resp != null && !resp.isEmpty()) {
                logger.debug("getTenantId() - get user tenantID via /me:  {}", (Object)resp);
                String string = resp.getString("tenantID");
                return string;
            }
            logger.info("getTenantId() - User tenantID from /me is empty.");
            return null;
        }
        catch (Exception e) {
            logger.error("getTenantId() - Unable to get tenantID via /me with exception {}", (Throwable)e);
            throw e;
        }
    }

    public RESTClient getCARESTClient() {
        return RESTClientFactory.getInstance().getClient(this.httpServletRequest);
    }

    protected String validatePutPayload(JsonObject objectIn, String[] supportedProps, String ... nonEmptyProps) {
        if (objectIn.isEmpty()) {
            logger.debug("Cannot update object of empty payload for PUT request");
            return MessageKeys.EMPTY_PAYLOAD.toString();
        }
        for (String key : objectIn.keySet()) {
            if (Arrays.asList(supportedProps).contains(key)) continue;
            return new Message(MessageKeys.UNSUPPORTED_PUT_DATA, (Object)key).toString();
        }
        return this.checkIfMandatoryFieldsAreEmpty(objectIn, nonEmptyProps);
    }

    private String checkIfMandatoryFieldsAreEmpty(JsonObject inputPayload, String ... nonEmptyProps) {
        for (String prop : nonEmptyProps) {
            if (!inputPayload.containsKey((Object)prop) || !StringUtils.isBlank((String)inputPayload.getString(prop))) continue;
            logger.debug("No value for key, {}, in payload, {}", (Object)prop, (Object)inputPayload);
            return new Message(MessageKeys.MISSING_VALUE, (Object)prop).toString();
        }
        return null;
    }
}

