/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.admin.core.resources;

import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonObject;
import com.ibm.bi.soap.services.SoapContext;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Responder {
    private SoapContext soapContext;
    private Request request;
    private static final Logger LOGGER = LoggerFactory.getLogger(Responder.class);

    public Responder(SoapContext soapContext, Request request) {
        this.soapContext = soapContext;
        this.request = request;
    }

    public Response cmQueryResponse(JsonObject data, boolean allowNotFound) {
        Response.ResponseBuilder builder = null;
        String cacheValidator = data.getString("cacheValidator");
        if ("GONE".equals(cacheValidator)) {
            builder = Response.status((Response.Status)Response.Status.GONE);
            cacheValidator = null;
        } else if ("NOT_SUPPORTED".equals(cacheValidator)) {
            cacheValidator = null;
        }
        EntityTag etag = null;
        if (cacheValidator != null) {
            etag = new EntityTag(cacheValidator);
            builder = this.request.evaluatePreconditions(etag);
        }
        if (builder == null) {
            JsonArray objects = data.getArray("objects");
            JsonObject result = new JsonObject();
            result.put("data", (Object)objects);
            builder = objects.size() == 0 && allowNotFound ? Response.status((Response.Status)Response.Status.NOT_FOUND) : Response.ok();
            builder.entity((Object)result).cacheControl(Responder.createCC());
        }
        if (etag != null) {
            builder = builder.tag(etag);
        }
        return this.soapContext.saveState(builder).build();
    }

    public static CacheControl createCC() {
        CacheControl cc = new CacheControl();
        cc.setPrivate(true);
        cc.setMustRevalidate(true);
        cc.setNoTransform(false);
        return cc;
    }

    public Response cmAddResponse(JsonObject data) {
        String uri = "";
        try {
            uri = (String)data.getObject("_meta").getObject("links").getObject("self").get("url");
        }
        catch (NullPointerException npe) {
            LOGGER.debug(npe.getMessage(), (Throwable)npe);
        }
        return this.soapContext.saveState(Response.status((Response.Status)Response.Status.CREATED).header("Location", (Object)uri)).build();
    }

    public Response cmAddResponse(JsonArray data) {
        String uri = "";
        try {
            uri = (String)data.getObject(0).getObject("_meta").getObject("links").getObject("self").get("url");
        }
        catch (NullPointerException npe) {
            LOGGER.debug(npe.getMessage(), (Throwable)npe);
        }
        return this.soapContext.saveState(Response.status((Response.Status)Response.Status.CREATED).entity(data.get(0)).header("Location", (Object)uri)).build();
    }

    public Response cmDeleteResponse(Long count) {
        JsonObject result = new JsonObject();
        result.put("count", (Object)count);
        return this.soapContext.saveState(Response.ok((Object)result)).build();
    }

    public Response cmUpdateResponse(JsonArray data) {
        return this.noContent();
    }

    public Response cmUpdateResponse(JsonObject data) {
        return this.noContent();
    }

    public Response noContent() {
        return this.soapContext.saveState(Response.noContent()).build();
    }
}

