/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.admin.core.resources;

import com.ibm.bi.admin.core.MessageKeys;
import com.ibm.bi.admin.core.exceptions.AdminException;
import com.ibm.bi.json.JsonObject;
import com.ibm.bi.platform.commons.messages.HttpException;
import com.ibm.bi.platform.commons.messages.Message;
import com.ibm.bi.rest.RESTClient;
import com.ibm.bi.rest.RESTClientFactory;
import java.util.HashSet;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class UserCapabilities {
    private static final String CAPABILITIES_URL = "/bi/v1/users/~/capabilities";
    protected HashSet<String> capabilities = null;
    protected String baseUrl;

    public UserCapabilities(HttpServletRequest servletRequest) throws AdminException {
        JsonObject obj = this.fetchCapabilities(servletRequest, CAPABILITIES_URL);
        List caps = (List)obj.get("userCapabilities");
        this.capabilities = new HashSet(caps);
    }

    public UserCapabilities(List<String> caps) {
        this.capabilities = new HashSet<String>(caps);
    }

    public boolean contains(String name) {
        return this.capabilities.contains(name);
    }

    public void verify(String ... capabilities) throws HttpException {
        for (String capability : capabilities) {
            if (this.contains(capability)) continue;
            throw new HttpException(403, new Message(MessageKeys.NO_CAPABILITY, (Object)capability));
        }
    }

    public boolean containsAll(List<String> names) {
        return this.capabilities.containsAll(names);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected JsonObject fetchCapabilities(HttpServletRequest servletRequest, String baseUrl) {
        try (RESTClient rest = RESTClientFactory.getInstance().getClient(servletRequest);){
            JsonObject jsonObject = rest.getResource(baseUrl, "application/json");
            return jsonObject;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

