/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.admin.core.utils;

import com.ibm.bi.admin.core.MessageKeys;
import com.ibm.bi.admin.core.exceptions.AdminException;
import com.ibm.bi.json.JsonObject;
import com.ibm.bi.json.JsonParser;
import com.ibm.bi.platform.commons.messages.HttpException;
import com.ibm.bi.platform.commons.messages.Message;
import com.ibm.bi.rest.RESTClient;
import com.ibm.bi.rest.RESTClientFactory;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationParameter<T> {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationParameter.class);
    private static final String CONFIG_SERVICE_URL = "/bi/v1/configuration/keys/global";
    private static final boolean VALUE_IS_STRING = true;
    private HttpServletRequest httpServletRequest;
    private String name;
    private T value = null;
    private T defaultValue;

    public ConfigurationParameter(HttpServletRequest httpServletRequest, String name, T defaultValue) {
        this.httpServletRequest = httpServletRequest;
        this.name = name;
        this.defaultValue = defaultValue;
    }

    private void queryConfigService() {
        JsonObject obj = null;
        try (RESTClient client = this.createRestClient();){
            StringBuilder buf = new StringBuilder().append(CONFIG_SERVICE_URL).append('/').append(this.name);
            int status = client.getResource(buf.toString());
            if (status == 403) {
                throw new HttpException(status, new Message(MessageKeys.ACCESS_DENIED));
            }
            if (status != 200) {
                throw new HttpException(500, new Message(MessageKeys.INTERNAL_ERROR));
            }
            obj = client.getResponseAsJsonObject();
            this.value = this.extractValue(obj);
        }
        catch (ClassCastException cce) {
            logger.error("Invalid format of configuration parameter " + this.name + ". Value is: " + obj, (Throwable)cce);
            throw new HttpException(500, (Throwable)cce, new Message(MessageKeys.INTERNAL_ERROR));
        }
        catch (IOException ioe) {
            logger.error("Unable to query configuration parameter " + this.name, (Throwable)ioe);
            throw new HttpException(500, (Throwable)ioe, new Message(MessageKeys.INTERNAL_ERROR));
        }
    }

    private T extractValue(JsonObject wrapper) throws IOException {
        if (wrapper == null) {
            return this.defaultValue;
        }
        Object v = wrapper.get(this.name);
        if (v == null) {
            return this.defaultValue;
        }
        Object result = v;
        if (v instanceof String) {
            JsonParser parser = new JsonParser();
            result = parser.parse((Reader)new StringReader((String)v));
        }
        return (T)result;
    }

    public String getETAG() {
        if (this.value == null) {
            this.queryConfigService();
        }
        return this.value == null ? "0" : Integer.toHexString(this.value.hashCode());
    }

    public T get() {
        if (this.value == null) {
            this.queryConfigService();
        }
        return this.value;
    }

    public void update(T value) {
        Object data = value;
        if (value instanceof String) {
            data = "" + '\"' + value + '\"';
        }
        try (RESTClient client = this.createRestClient();){
            JsonObject resource = new JsonObject();
            resource.put(this.name, data);
            int status = client.updateResource(CONFIG_SERVICE_URL, "application/json", resource);
            if (status >= 400) {
                logger.error("Unable to update configuration parameter " + this.name);
                throw new AdminException(Response.Status.fromStatusCode((int)status));
            }
            this.value = value;
        }
        catch (IOException e) {
            logger.error("Unable to update configuration parameter " + this.name, (Throwable)e);
            throw new HttpException(500, (Throwable)e, new Message(MessageKeys.INTERNAL_ERROR));
        }
    }

    public String getName() {
        return this.name;
    }

    protected RESTClient createRestClient() {
        return RESTClientFactory.getInstance().getClient(this.httpServletRequest);
    }
}

