/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.admin.commons.filters;

import com.ibm.bi.admin.commons.filters.AdminRequestWrapper;
import com.ibm.bi.admin.commons.filters.FilterBase;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebFilter(filterName="CognosNsPathOverrideFilter", urlPatterns={"/v1/namespaces/*"}, dispatcherTypes={DispatcherType.REQUEST, DispatcherType.FORWARD})
public class CognosNsPathOverrideFilter
extends FilterBase
implements Filter {
    private static final String V1 = "/v1";
    private static final Logger LOGGER = LoggerFactory.getLogger(CognosNsPathOverrideFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
        LOGGER.info("CognosNsPathOverrideBasicFilter initialized");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String oldPath = httpRequest.getRequestURI();
        Map parameterMap = request.getParameterMap();
        HashMap<String, String[]> additionalParams = new HashMap<String, String[]>(parameterMap);
        if (StringUtils.contains((String)oldPath, (String)"xOg__")) {
            String tenantFolderId = this.getTenantNamespaceFolderId(httpRequest, additionalParams, "xOg__");
            if (!tenantFolderId.equals("xOg__")) {
                int i = oldPath.indexOf(V1);
                String path = oldPath.substring(i);
                String newPath = path.replace("xOg__", tenantFolderId);
                AdminRequestWrapper enhancedHttpRequest = new AdminRequestWrapper(httpRequest, false, additionalParams);
                request.getRequestDispatcher(newPath).forward((ServletRequest)enhancedHttpRequest, response);
            } else {
                chain.doFilter(request, response);
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
    }
}

