/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.admin.commons.filters;

import com.ibm.bi.admin.commons.filters.AdminRequestWrapper;
import com.ibm.bi.admin.commons.filters.FilterBase;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebFilter(filterName="CognosNsQueryParamOverrideFilter", urlPatterns={"/v1/groups", "/v1/roles", "/v1/folders"}, dispatcherTypes={DispatcherType.REQUEST, DispatcherType.FORWARD})
public class CognosNsQueryParamOverrideFilter
extends FilterBase
implements Filter {
    private static final String PID = "pid";
    private static final Logger LOGGER = LoggerFactory.getLogger(CognosNsQueryParamOverrideFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
        LOGGER.info("CognosNsQueryParamOverrideBasicFilter initialized");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        Map parameterMap = request.getParameterMap();
        HashMap<String, String[]> additionalParams = new HashMap<String, String[]>(parameterMap);
        if (parameterMap.containsKey(PID) && this.checkIfParameterContainsCognosNs((String[])parameterMap.get(PID))) {
            String tenantFolderId = this.getTenantNamespaceFolderId(httpRequest, additionalParams, ((String[])parameterMap.get(PID))[0]);
            additionalParams.put(PID, new String[]{tenantFolderId});
        }
        AdminRequestWrapper enhancedHttpRequest = new AdminRequestWrapper(httpRequest, false, additionalParams);
        chain.doFilter((ServletRequest)enhancedHttpRequest, response);
    }

    private boolean checkIfParameterContainsCognosNs(String[] parameterValues) {
        return Arrays.stream(parameterValues).anyMatch("xOg__"::equals);
    }

    public void destroy() {
    }
}

