/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.admin.commons.model;

import com.ibm.bi.admin.commons.exception.AdminException;
import com.ibm.bi.admin.commons.model.search.ConditionalExpression;
import com.ibm.bi.admin.commons.model.search.FunctionCall;
import com.ibm.bi.admin.commons.model.search.PredicateExpression;
import com.ibm.bi.admin.commons.model.search.SearchFilter;
import com.ibm.bi.admin.commons.model.search.SearchFilterParser;
import com.ibm.bi.admin.commons.utilities.AdminCommonMessageKeys;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;

public class CMQueryOption {
    private int objectsFrom = 0;
    private int objectsNumber = 100;
    private List<Map<String, String>> orderBy = null;
    private String type = null;
    private String pid = null;
    private int maxHitsResults = 50;
    private String ordering = null;
    private SearchFilter filter;
    private List<String> fields = null;
    private Boolean addBuiltInObjects = false;

    public int getObjectsFrom() {
        return this.objectsFrom;
    }

    public void setObjectsFrom(int objectsFrom) {
        this.objectsFrom = objectsFrom;
    }

    public int getObjectsNumber() {
        return this.objectsNumber;
    }

    public void setObjectsNumber(int objectsNumber) {
        this.objectsNumber = objectsNumber;
    }

    public List<Map<String, String>> getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(List<Map<String, String>> orderBy) {
        this.orderBy = orderBy;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setFilter(SearchFilter filter) {
        this.filter = filter;
    }

    public SearchFilter getFilter() {
        return this.filter;
    }

    public Boolean getAddBuiltInObjects() {
        return this.addBuiltInObjects;
    }

    public void setAddBuiltInObjects(Boolean addBuiltInObjects) {
        this.addBuiltInObjects = addBuiltInObjects;
    }

    public static CMQueryOption parseFrom(HttpServletRequest request) {
        StringTokenizer tokenizer;
        String pageInfo = request.getParameter("page");
        String sorting = request.getParameter("sorting");
        String type = request.getParameter("types");
        String pid = request.getParameter("pid");
        String search = request.getParameter("search");
        String filter = request.getParameter("searchFilter");
        String fields = request.getParameter("fields");
        Boolean addBuiltinObjects = Boolean.parseBoolean(request.getParameter("addBuiltinObjects"));
        CMQueryOption option = new CMQueryOption();
        option.setType(type);
        option.setPid(pid);
        option.setAddBuiltInObjects(addBuiltinObjects);
        if (pageInfo != null) {
            tokenizer = new StringTokenizer(pageInfo, "|");
            option.setObjectsFrom(Integer.parseInt(tokenizer.nextToken()));
            option.setObjectsNumber(Integer.parseInt(tokenizer.nextToken()));
        }
        if (sorting != null) {
            tokenizer = new StringTokenizer(sorting, "|");
            ArrayList<Map<String, String>> orderBy = new ArrayList<Map<String, String>>();
            HashMap<String, String> orderByItem = new HashMap<String, String>();
            orderByItem.put("propName", tokenizer.nextToken());
            String order = tokenizer.nextToken();
            orderByItem.put("order", order.equalsIgnoreCase("asc") ? "ascending" : "descending");
            orderBy.add(orderByItem);
            option.setOrderBy(orderBy);
            option.setOrdering(order.equalsIgnoreCase("asc") ? "ascending" : "descending");
        }
        if (search != null && filter != null) {
            throw new AdminException(AdminCommonMessageKeys.PARAMETER_ERROR);
        }
        if (search != null && !search.isEmpty()) {
            tokenizer = new StringTokenizer(search, "|");
            tokenizer.nextToken();
            String paramater = tokenizer.nextToken();
            if (!paramater.matches("[a-zA-Z0-9!#$%+-=_.@{} ]+")) {
                throw new AdminException(AdminCommonMessageKeys.INVALID_CHARACTERS_ERROR);
            }
            FunctionCall filter1 = new FunctionCall("contains", new String[]{"defaultName", paramater});
            FunctionCall filter2 = new FunctionCall("contains", new String[]{"email", paramater});
            option.setFilter(new PredicateExpression(new ConditionalExpression("or", filter1, filter2)));
        }
        if (filter != null && !filter.isEmpty()) {
            option.setFilter(SearchFilterParser.parse(filter));
        }
        if (fields != null && !fields.isEmpty()) {
            tokenizer = new StringTokenizer(fields, ",");
            ArrayList<String> filedsList = new ArrayList<String>();
            while (tokenizer.hasMoreTokens()) {
                filedsList.add(tokenizer.nextToken());
            }
            option.setFields(filedsList);
        }
        return option;
    }

    public String getPid() {
        return this.pid;
    }

    public void setPid(String pid) {
        this.pid = pid;
    }

    public int getMaxHitsResults() {
        return this.maxHitsResults;
    }

    public void setMaxHitsResults(int maxHitsResults) {
        this.maxHitsResults = maxHitsResults;
    }

    public String getOrdering() {
        return this.ordering;
    }

    public void setOrdering(String ordering) {
        this.ordering = ordering;
    }

    public List<String> getFields() {
        return this.fields;
    }

    public void setFields(List<String> fields) {
        this.fields = fields;
    }
}

