/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.crypto.pkcs;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.misc.Configuration;
import com.cognos.accman.jcam.crypto.misc.JVMEnvironment;
import com.cognos.accman.jcam.crypto.misc.SymmetricAlgorithmManager;
import com.cognos.accman.jcam.crypto.pkcs.EncryptedContentInfoGenerator;
import com.cognos.accman.jcam.crypto.pkcs.RecipientInfoGenerator;
import com.cognos.accman.res.MessageSet;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.Vector;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.RC2ParameterSpec;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.cms.EncryptedContentInfo;
import org.bouncycastle.asn1.cms.EnvelopedData;

class EnvelopedDataGenerator {
    private byte[] content = null;
    private Vector recipients = new Vector();

    public void addRecipient(X509Certificate recipient) {
        this.recipients.add(recipient);
    }

    public void addRecipients(X509Certificate[] recipients) {
        for (int i = 0; i < recipients.length; ++i) {
            this.recipients.add(recipients[i]);
        }
    }

    public void setContent(byte[] content) {
        this.content = content;
    }

    public EnvelopedData generate() throws CAMCryptoException {
        Cipher cipher;
        SecretKey key;
        String configEncrAlg = Configuration.getInstance().getConfidentialityAlgorithm();
        String shortName = SymmetricAlgorithmManager.getShortName(configEncrAlg);
        String longName = SymmetricAlgorithmManager.getLongName(configEncrAlg);
        int effectiveKeySize = SymmetricAlgorithmManager.getEffectiveKeySize(configEncrAlg);
        String algOID = SymmetricAlgorithmManager.getId(configEncrAlg);
        RC2ParameterSpec aps = null;
        if (configEncrAlg.equalsIgnoreCase("RC2") || configEncrAlg.equalsIgnoreCase("RC2-40")) {
            aps = new RC2ParameterSpec(effectiveKeySize);
        }
        try {
            String jceProvider = JVMEnvironment.getInstance().getJCEProvider();
            KeyGenerator keyGenerator = KeyGenerator.getInstance(shortName, jceProvider);
            keyGenerator.init(effectiveKeySize);
            key = keyGenerator.generateKey();
            cipher = Cipher.getInstance(longName, jceProvider);
            if (aps != null) {
                cipher.init(1, (Key)key, aps);
            } else {
                cipher.init(1, key);
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_pkcs7_unsupported_alg", new String[]{longName}));
        }
        catch (NoSuchPaddingException e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_pkcs7_unsupported_alg", new String[]{longName}));
        }
        catch (Exception e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_pkcs7_internal_error"));
        }
        Object[] ra = this.recipients.toArray();
        X509Certificate[] certs = new X509Certificate[ra.length];
        System.arraycopy(ra, 0, certs, 0, ra.length);
        ASN1Set recipientInfos = RecipientInfoGenerator.generate(certs, key);
        EncryptedContentInfo encryptedContentInfo = EncryptedContentInfoGenerator.generate(cipher, this.content, algOID, effectiveKeySize);
        ASN1Set unprotectedAttrs = null;
        return new EnvelopedData(null, recipientInfos, encryptedContentInfo, unprotectedAttrs);
    }
}

