/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.crypto.xml;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.misc.Configuration;
import com.cognos.accman.jcam.crypto.misc.CryptoWrapper;
import com.cognos.accman.jcam.crypto.misc.EncodedCSK_HMAC_Digest;
import com.cognos.accman.jcam.crypto.misc.IPFAuditFunction;
import com.cognos.accman.jcam.crypto.misc.IPFTraceFunction;
import com.cognos.accman.jcam.crypto.xml.BaseTrustedSession;
import com.cognos.accman.jcam.crypto.xml.GenericTrustedSessionToken2;
import com.cognos.accman.jcam.crypto.xml.GenericTrustedSessionToken3;
import com.cognos.accman.res.MessageSet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import javax.crypto.Mac;

public class GenericTrustedSession
extends BaseTrustedSession {
    static final byte[] resetter = "<".getBytes();
    static final int resetterLen = resetter.length;
    static final byte[] opener = "<item".getBytes();
    static final int openerLen = opener.length;
    static final byte[] opener2 = "<userCapabilities".getBytes();
    static final int opener2Len = opener2.length;
    static final byte[] closer = "</item>".getBytes();
    static final int closerLen = closer.length;
    static final byte[] closer2 = "</userCapabilities>".getBytes();
    static final int closer2Len = closer2.length;
    static final byte[] padding = ":".getBytes();
    static final byte[] elementEnd = ">".getBytes();
    static final int elementEndLen = elementEnd.length;
    int closerLimit;
    int openerLimit;
    int closer2Limit;
    int opener2Limit;
    int resetterLimit;
    int elementEndLimit;
    private static final byte VERSION_1 = 1;
    private static final byte VERSION_2 = 2;
    private static final byte VERSION_3 = 3;
    private final String classId = "GenericTrustedSession";

    public GenericTrustedSession(String serviceID) throws CAMCryptoException {
    }

    @Deprecated
    public byte[] createTrustToken(byte[] token) throws CAMCryptoException {
        return this.createTrustToken(token, null, 2);
    }

    public byte[] createTrustToken(byte[] token, String passportID) throws CAMCryptoException {
        if (Configuration.getInstance().getEnableSecureUserCapabilitiesCache()) {
            return this.createTrustToken(token, passportID, 3);
        }
        return this.createTrustToken(token, null, 2);
    }

    public byte[] test_method_createTrustToken(byte[] token, String passport, int version) throws CAMCryptoException {
        return this.createTrustToken(token, passport, version);
    }

    private byte[] createTrustToken(byte[] token, String passportID, int version) throws CAMCryptoException {
        byte[] secureToken;
        boolean enableSecureUserCapabilitiesCaches = Configuration.getInstance().getEnableSecureUserCapabilitiesCache();
        if (IPFTraceFunction.isEnabled()) {
            IPFTraceFunction ipfFunction = new IPFTraceFunction("createTrustToken", this);
            ipfFunction.addParameter("token", new String(token));
            ipfFunction.addParameter("passportID", passportID);
            ipfFunction.addParameter("version", version);
            ipfFunction.addParameter("EnableSecureUserCapabilitiesCaches", enableSecureUserCapabilitiesCaches);
            ipfFunction.logEntry();
            ipfFunction = null;
        }
        if (enableSecureUserCapabilitiesCaches && version < 3) {
            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_unknown_encoded_plaintext_version"));
        }
        try {
            if (token == null || token.length == 0) {
                throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_null_soap_request"));
            }
        }
        catch (CAMCryptoException e) {
            new IPFAuditFunction("createTrustToken", this).logExit(e);
            throw e;
        }
        this.validateIdentity();
        this.updateCSK();
        byte[] c14nXml = this.camCanonicalizer(token);
        if (version == 1) {
            secureToken = this.writeToken1(c14nXml);
        } else if (version == 2) {
            secureToken = this.writeToken2(c14nXml);
        } else if (version == 3) {
            try {
                if (passportID == null || passportID.length() == 0) {
                    throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_null_soap_request"));
                }
            }
            catch (CAMCryptoException e) {
                new IPFAuditFunction("createTrustToken", this).logExit(e);
                throw e;
            }
            secureToken = this.writeToken3(c14nXml, passportID);
        } else {
            try {
                throw new CAMCryptoException("");
            }
            catch (CAMCryptoException e) {
                new IPFAuditFunction("createTrustToken", this).logExit(e);
                throw e;
            }
        }
        byte[] cammacenc = CryptoWrapper.encodeBase64(secureToken);
        if (IPFTraceFunction.isEnabled()) {
            new IPFTraceFunction("createTrustToken", this).logExit(cammacenc);
        }
        return cammacenc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] writeToken1(byte[] c14nXml) throws CAMCryptoException {
        byte[] hmacResult;
        Mac mac;
        Mac mac2 = mac = this.getCurrentCSKMac();
        synchronized (mac2) {
            mac.reset();
            mac.update((byte)1);
            mac.update("GenericTrustedSession".getBytes());
            mac.update(c14nXml);
            hmacResult = mac.doFinal();
        }
        byte[] currentCskDigest = this.getCurrentCSKDigest();
        EncodedCSK_HMAC_Digest cskHmacDigest = new EncodedCSK_HMAC_Digest(currentCskDigest, hmacResult);
        byte[] encCSKHmacDigest = cskHmacDigest.getEncodedHMACDigest();
        int tokenlen = 1 + encCSKHmacDigest.length;
        byte[] secureToken = new byte[tokenlen];
        int pos = 0;
        secureToken[pos] = 1;
        System.arraycopy(encCSKHmacDigest, 0, secureToken, ++pos, encCSKHmacDigest.length);
        return secureToken;
    }

    private byte[] writeToken2(byte[] c14nXml) throws CAMCryptoException {
        Configuration config = Configuration.getInstance();
        String digestAlgorithm = config.getDigestAlgorithm();
        byte[] currentCskDigest = this.getCurrentCSKDigest();
        ByteArrayOutputStream secureToken = new ByteArrayOutputStream();
        GenericTrustedSessionToken2 token = new GenericTrustedSessionToken2(this, digestAlgorithm, currentCskDigest, c14nXml);
        token.writeToken(secureToken);
        return secureToken.toByteArray();
    }

    private byte[] writeToken3(byte[] c14nXml, String passportID) throws CAMCryptoException {
        Configuration config = Configuration.getInstance();
        String digestAlgorithm = config.getDigestAlgorithm();
        byte[] currentCskDigest = this.getCurrentCSKDigest();
        ByteArrayOutputStream secureToken = new ByteArrayOutputStream();
        GenericTrustedSessionToken3 token = new GenericTrustedSessionToken3(this, digestAlgorithm, currentCskDigest, c14nXml, passportID);
        token.writeToken(secureToken);
        return secureToken.toByteArray();
    }

    public boolean verifyTrustToken(byte[] token, byte[] xml, String passportID) throws CAMCryptoException {
        return this.verifyTrustTokenInternal(token, xml, passportID);
    }

    @Deprecated
    public boolean verifyTrustToken(byte[] token, byte[] xml) throws CAMCryptoException {
        return this.verifyTrustTokenInternal(token, xml, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean verifyTrustTokenInternal(byte[] token, byte[] xml, String passportID) throws CAMCryptoException {
        byte[] hmacResult;
        Mac thisMac;
        EncodedCSK_HMAC_Digest cskHmacDigest;
        byte[] decodedToken;
        boolean enableSecureUserCapabilitiesCaches = Configuration.getInstance().getEnableSecureUserCapabilitiesCache();
        if (IPFTraceFunction.isEnabled()) {
            IPFTraceFunction ipfFunction = new IPFTraceFunction("verifyTrustToken", this);
            ipfFunction.addParameter("token", new String(token));
            ipfFunction.addParameter("passportID", passportID);
            ipfFunction.addParameter("xml", new String(xml));
            ipfFunction.addParameter("EnableSecureUserCapabilitiesCaches", enableSecureUserCapabilitiesCaches);
            ipfFunction.logEntry();
            ipfFunction = null;
        }
        try {
            if (token == null || token.length == 0) {
                throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_null_soap_request"));
            }
        }
        catch (CAMCryptoException e) {
            new IPFAuditFunction("verifyTrustToken", this).logExit(e);
            throw e;
        }
        try {
            if (xml == null || xml.length == 0) {
                throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_null_soap_request"));
            }
        }
        catch (CAMCryptoException e) {
            new IPFAuditFunction("verifyTrustToken", this).logExit(e);
            throw e;
        }
        byte[] c14nXml = this.camCanonicalizer(xml);
        try {
            decodedToken = CryptoWrapper.decodeBase64(token);
        }
        catch (Exception e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_bad_base64_input"));
        }
        int pos = 0;
        byte reqVersion = decodedToken[pos];
        if (enableSecureUserCapabilitiesCaches && reqVersion < 3) {
            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_unknown_encoded_plaintext_version"));
        }
        if (reqVersion == 2) {
            GenericTrustedSessionToken2 tokenA = new GenericTrustedSessionToken2();
            ByteArrayInputStream in = new ByteArrayInputStream(decodedToken);
            tokenA.readToken(in);
            GenericTrustedSessionToken2 tokenB = new GenericTrustedSessionToken2(this, tokenA, c14nXml);
            return tokenA.verifyToken(tokenB);
        }
        if (reqVersion == 3) {
            try {
                if (passportID == null || passportID.length() == 0) {
                    throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_null_soap_request"));
                }
            }
            catch (CAMCryptoException e) {
                new IPFAuditFunction("verifyTrustToken", this).logExit(e);
                throw e;
            }
            GenericTrustedSessionToken3 tokenA = new GenericTrustedSessionToken3();
            ByteArrayInputStream in = new ByteArrayInputStream(decodedToken);
            tokenA.readToken(in);
            GenericTrustedSessionToken3 tokenB = new GenericTrustedSessionToken3(this, tokenA, c14nXml, passportID);
            return tokenA.verifyToken(tokenB);
        }
        if (reqVersion != 1) {
            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_invalid_message_version"));
        }
        int hmacTokenlen = decodedToken.length - 1;
        byte[] hmacToken = new byte[hmacTokenlen];
        System.arraycopy(decodedToken, ++pos, hmacToken, 0, hmacTokenlen);
        try {
            cskHmacDigest = new EncodedCSK_HMAC_Digest(hmacToken, this.hmacLength);
            thisMac = this.getMacGivenCSKDigest(cskHmacDigest.getCSKDigest());
        }
        catch (CAMCryptoException e) {
            IPFTraceFunction.trace("Error bad CSK HMAC digest");
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_gts_csk_hamc_digest_error"));
        }
        Mac mac = thisMac;
        synchronized (mac) {
            thisMac.reset();
            thisMac.update(reqVersion);
            thisMac.update("GenericTrustedSession".getBytes());
            thisMac.update(c14nXml);
            hmacResult = thisMac.doFinal();
        }
        boolean bReturn = false;
        byte[] origHmac = cskHmacDigest.getHMACDigest();
        if (Arrays.equals(hmacResult, origHmac)) {
            bReturn = true;
        } else {
            IPFTraceFunction.trace("HMAC mismatch, message was modified");
        }
        new IPFTraceFunction("verifyTrustToken", this).logExit(bReturn);
        return bReturn;
    }

    private void canonicalizeInit(int sz) {
        this.closerLimit = sz - closerLen;
        this.openerLimit = sz - openerLen;
        this.closer2Limit = sz - closer2Len;
        this.opener2Limit = sz - opener2Len;
        this.resetterLimit = sz - resetterLen;
        this.elementEndLimit = sz - elementEndLen;
    }

    private byte[] newCanonicalizer(byte[] c14nXML) {
        int sz = c14nXML.length;
        boolean endReached = false;
        byte[] workXML = new byte[sz];
        int currentIndex = 0;
        int forwardIndex = 0;
        int workIndex = 0;
        int sectionStart = 0;
        int sectionLen = 0;
        int type = 0;
        int actualStartIndex = 0;
        this.canonicalizeInit(sz);
        while (!endReached && currentIndex >= 0) {
            if ((currentIndex = this.FindNextOpener(currentIndex, opener, openerLen, c14nXML, sz)) == -1) {
                endReached = true;
                continue;
            }
            if (this.isOpener(currentIndex, c14nXML)) {
                type = 1;
            } else if (this.isOpener2(currentIndex, c14nXML)) {
                type = 2;
            }
            forwardIndex = this.FindNextToken(sz, c14nXML, currentIndex + 1);
            if (forwardIndex == -1) {
                endReached = true;
                continue;
            }
            if (this.isOpener(forwardIndex, c14nXML) || this.isOpener2(forwardIndex, c14nXML)) {
                currentIndex = forwardIndex;
                continue;
            }
            if (this.isCloser(forwardIndex, c14nXML) || this.isCloser2(forwardIndex, c14nXML)) {
                if (this.isMatchingPair(type, c14nXML, forwardIndex) && (actualStartIndex = this.skipAttributes(currentIndex, c14nXML, forwardIndex)) != -1) {
                    sectionStart = actualStartIndex + 1;
                    sectionLen = forwardIndex - actualStartIndex - 1;
                    this.ExtractSection(sectionStart, sectionLen, c14nXML, workIndex, workXML);
                    workXML[workIndex += sectionLen] = padding[0];
                    ++workIndex;
                }
                currentIndex = forwardIndex;
                continue;
            }
            currentIndex = forwardIndex;
        }
        byte[] camXML = new byte[workIndex];
        if (workIndex > 0) {
            System.arraycopy(workXML, 0, camXML, 0, workIndex);
        }
        return camXML;
    }

    private int skipAttributes(int currentIndex, byte[] c14nXML, int forwardIndex) {
        while (!this.isElementEnd(currentIndex, c14nXML) && currentIndex < forwardIndex) {
            ++currentIndex;
        }
        if (currentIndex >= forwardIndex) {
            return -1;
        }
        return currentIndex;
    }

    private boolean isElementEnd(int currentIndex, byte[] c14nXML) {
        return this.genericIsObject(currentIndex, c14nXML, this.elementEndLimit, elementEnd, elementEndLen);
    }

    private boolean isMatchingPair(int type, byte[] c14nXML, int forwardIndex) {
        boolean matchingPair = type == 1 ? this.isCloser(forwardIndex, c14nXML) : this.isCloser2(forwardIndex, c14nXML);
        return matchingPair;
    }

    private int FindNextToken(int sz, byte[] c14nXML, int currentIndex) {
        boolean endReached = false;
        while (!endReached) {
            if (currentIndex >= this.resetterLimit) {
                endReached = true;
            } else if (this.isResetter(currentIndex, c14nXML)) {
                return currentIndex;
            }
            if (currentIndex >= this.openerLimit) {
                endReached = true;
            } else if (this.isOpener(currentIndex, c14nXML)) {
                return currentIndex;
            }
            if (currentIndex >= this.closerLimit) {
                endReached = true;
            } else if (this.isCloser(currentIndex, c14nXML)) {
                return currentIndex;
            }
            if (currentIndex >= this.opener2Limit) {
                endReached = true;
            } else if (this.isOpener2(currentIndex, c14nXML)) {
                return currentIndex;
            }
            if (currentIndex >= this.closer2Limit) {
                endReached = true;
            } else if (this.isCloser2(currentIndex, c14nXML)) {
                return currentIndex;
            }
            ++currentIndex;
        }
        return -1;
    }

    private boolean isResetter(int currentIndex, byte[] c14nXML) {
        return this.genericIsObject(currentIndex, c14nXML, this.resetterLimit, resetter, resetterLen);
    }

    private boolean isOpener(int currentIndex, byte[] c14nXML) {
        return this.genericIsObject(currentIndex, c14nXML, this.openerLimit, opener, openerLen);
    }

    private boolean isOpener2(int currentIndex, byte[] c14nXML) {
        return this.genericIsObject(currentIndex, c14nXML, this.opener2Limit, opener2, opener2Len);
    }

    private boolean isCloser(int currentIndex, byte[] c14nXML) {
        return this.genericIsObject(currentIndex, c14nXML, this.closerLimit, closer, closerLen);
    }

    private boolean isCloser2(int currentIndex, byte[] c14nXML) {
        return this.genericIsObject(currentIndex, c14nXML, this.closer2Limit, closer2, closer2Len);
    }

    private boolean genericIsObject(int currentIndex, byte[] c14nXML, int objectLimit, byte[] object, int objectLen) {
        return currentIndex < objectLimit && GenericTrustedSession.byteCompare(c14nXML, currentIndex, objectLen, object);
    }

    private int FindNextOpener(int startIndex, byte[] opener, int openerLen, byte[] c14nXML, int stringLen) {
        boolean found = false;
        boolean endReached = false;
        int beyondLimit = stringLen - openerLen;
        if (startIndex >= beyondLimit) {
            return -1;
        }
        while (!found && !endReached) {
            if (this.isOpener(startIndex, c14nXML) || this.isOpener2(startIndex, c14nXML)) {
                found = true;
                continue;
            }
            if (startIndex + 1 >= this.openerLimit || startIndex + 1 >= this.opener2Limit) {
                endReached = true;
                continue;
            }
            ++startIndex;
        }
        if (endReached) {
            startIndex = -1;
        }
        return startIndex;
    }

    private void ExtractSection(int startIndex, int length, byte[] source, int targetIndex, byte[] target) {
        for (int i = 0; i < length; ++i) {
            target[targetIndex + i] = source[startIndex + i];
        }
    }

    public byte[] camCanonicalizer(byte[] c14nXML) {
        return this.newCanonicalizer(c14nXML);
    }

    private static boolean byteCompare(byte[] c14nXML, int start, int length, byte[] compareString) {
        if (compareString.length != length) {
            return false;
        }
        if (start > c14nXML.length) {
            return false;
        }
        int c14nXMLIndex = start;
        int compareStringIndex = 0;
        while (compareStringIndex < length) {
            if (c14nXML[c14nXMLIndex] != compareString[compareStringIndex]) {
                return false;
            }
            ++compareStringIndex;
            ++c14nXMLIndex;
        }
        return true;
    }
}

