/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.soap.schema.handlers;

import com.ibm.bi.json.JsonParser;
import com.ibm.bi.json.JsonWriter;
import com.ibm.bi.soap.schema.DeserializationContext;
import com.ibm.bi.soap.schema.Property;
import com.ibm.bi.soap.schema.SerializationContext;
import com.ibm.bi.soap.schema.handlers.DefaultPropertyHandler;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import javax.xml.stream.XMLStreamException;

public class JsonDeSerializingHandler
extends DefaultPropertyHandler {
    @Override
    public Object deserialize(DeserializationContext dc, Property prop) throws XMLStreamException {
        Object strvalue = super.deserialize(dc, prop);
        if (dc.json.isNull(strvalue)) {
            return dc.json.createObject();
        }
        JsonParser parser = new JsonParser(dc.json);
        try {
            return parser.parse((Reader)new StringReader(dc.json.toString(strvalue)));
        }
        catch (IOException ioe) {
            throw new XMLStreamException(ioe);
        }
    }

    @Override
    public void serialize(SerializationContext sc, Property prop, Object value) {
        if (!sc.json.isNull(value)) {
            if (!(value instanceof Map)) {
                throw new IllegalArgumentException("Property '" + prop.getName() + "' conains invalid value type " + value.getClass().getCanonicalName());
            }
            if (((Map)value).isEmpty()) {
                value = sc.json.createString("");
            } else {
                JsonWriter wrt = new JsonWriter(sc.json, false);
                StringWriter sw = new StringWriter();
                try {
                    wrt.write((Writer)sw, value);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                value = sc.json.createString(sw.toString());
            }
        }
        super.serialize(sc, prop, value);
    }
}

