/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.soap.services;

import com.ibm.bi.json.JsonFactory;
import com.ibm.bi.soap.schema.Method;
import com.ibm.bi.soap.schema.SoapFaultHandler;
import com.ibm.bi.soap.schema.TypeLibrary;
import com.ibm.bi.soap.services.BiBus;
import com.ibm.bi.soap.services.EmsBaseService;
import com.ibm.bi.soap.services.ServiceLoader;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;

public class MonitorService
extends EmsBaseService
implements SoapFaultHandler {
    static Method RUN_SPECIFICATION;
    static Method NEXT_PAGE;
    static Method PREVIOUS_PAGE;
    static Method FIRST_PAGE;
    static Method LAST_PAGE;
    static Method RELEASE;
    static Method RUN_COMMAND;
    static Method ADD;
    static Method NOTIFY;

    static void init(TypeLibrary typeLib) throws XMLStreamException, IOException {
        HashMap<String, Method> methods;
        ServiceLoader serviceLoader = new ServiceLoader();
        try (InputStream is = MonitorService.class.getResourceAsStream("monitorService.xml");){
            methods = serviceLoader.load(typeLib, is);
        }
        RUN_SPECIFICATION = methods.get("runSpecification");
        NEXT_PAGE = methods.get("nextPage");
        PREVIOUS_PAGE = methods.get("previousPage");
        FIRST_PAGE = methods.get("firstPage");
        LAST_PAGE = methods.get("lastPage");
        RELEASE = methods.get("release");
        RUN_COMMAND = methods.get("run");
        ADD = methods.get("add");
        NOTIFY = methods.get("notify");
    }

    public MonitorService(BiBus bus) {
        super(bus);
    }

    public Map runSpecification(String specification, Map options) throws Exception {
        JsonFactory json = this.bus.getJsonFactory();
        Map request = json.createObject();
        Map specMap = json.createObject();
        specMap.put(json.createString("value"), json.createString(specification));
        specMap.put(json.createString("type"), json.createString("monitorServiceSpecification"));
        request.put(json.createString("specification"), specMap);
        List parameterValues = json.createArray();
        request.put(json.createString("parameterValues"), parameterValues);
        List opts = this.parseOptions(options);
        request.put(json.createString("options"), opts);
        return (Map)this.invoke(RUN_SPECIFICATION, request);
    }

    public Object run(String objectPath, List options, List parameterValues) throws Exception {
        Map obj = this.createRunRequest(objectPath, options, parameterValues);
        return this.invoke(RUN_COMMAND, obj);
    }

    private Map createRunRequest(String objectPath, List options, List parameterValues) {
        JsonFactory json = this.bus.getJsonFactory();
        Map obj = json.createObject();
        obj.put("objectPath", objectPath);
        obj.put("parameterValues", parameterValues);
        obj.put("options", options);
        return obj;
    }

    public Map nextPage(Map primaryRequest, Map options) throws Exception {
        return (Map)this.invoke(NEXT_PAGE, this.createSecondaryRequest(primaryRequest, options));
    }

    public Map previousePage(Map primaryRequest, Map options) throws Exception {
        return (Map)this.invoke(PREVIOUS_PAGE, this.createSecondaryRequest(primaryRequest, options));
    }

    public Map firstPage(Map primaryRequest, Map options) throws Exception {
        return (Map)this.invoke(FIRST_PAGE, this.createSecondaryRequest(primaryRequest, options));
    }

    public Map lastPage(Map primaryRequest, Map options) throws Exception {
        return (Map)this.invoke(LAST_PAGE, this.createSecondaryRequest(primaryRequest, options));
    }

    public void release(Map primaryRequest) throws Exception {
        this.invoke(RELEASE, this.createReleaseRequest(primaryRequest));
    }

    public Map add(String eventID, List objects, Map options) throws Exception {
        Map obj = this.createAddRequest(eventID, objects, options);
        return (Map)this.invoke(ADD, obj);
    }

    private Map createAddRequest(String eventID, List objects, Map options) {
        JsonFactory json = this.bus.getJsonFactory();
        Map request = json.createObject();
        request.put("eventID", eventID);
        request.put("objects", objects);
        if (options != null) {
            List opts = json.createArray();
            Map dependentStep = json.createObject();
            dependentStep.put(json.createString("type"), json.createString("monitorAddOptionBoolean"));
            dependentStep.put(json.createString("name"), json.createString("dependentStep"));
            dependentStep.put(json.createString("value"), options.get("dependentStep"));
            opts.add(dependentStep);
            request.put(json.createString("options"), opts);
        }
        return request;
    }

    public Map notify(Map eventID, String status) throws Exception {
        JsonFactory json = this.bus.getJsonFactory();
        Map request = json.createObject();
        request.put(json.createString("eventID"), eventID);
        request.put(json.createString("eventStatus"), status);
        return (Map)this.invoke(NOTIFY, request);
    }
}

