/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.admin.crypto.utilities;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.accman.jcam.crypto.EncryptingSession;
import java.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Crypto {
    private static final Logger logger = LoggerFactory.getLogger(Crypto.class);
    private static volatile CAMFactory camFactory = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private CAMFactory getCamFactory() {
        if (camFactory != null) return camFactory;
        Class<Crypto> clazz = Crypto.class;
        synchronized (Crypto.class) {
            try {
                if (camFactory != null) return camFactory;
                camFactory = new CAMFactory("ADM-REST");
            }
            catch (CAMCryptoException e) {
                logger.error("Error initializing crypto library", (Throwable)e);
                throw new RuntimeException(e);
            }
            return camFactory;
        }
    }

    public String encryptString(String data) {
        try {
            EncryptingSession es = this.getCamFactory().createEncryptingSession();
            byte[] encrypted = es.encryptData(data.getBytes("utf-8"));
            return Base64.getEncoder().encodeToString(encrypted);
        }
        catch (Exception e) {
            logger.error("Unable to encrypt data", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public String decryptString(String data) {
        try {
            byte[] encrypted = Base64.getDecoder().decode(data);
            EncryptingSession es = this.getCamFactory().createEncryptingSession();
            byte[] decrypted = es.decryptData(encrypted);
            return new String(decrypted, "utf-8");
        }
        catch (Exception e) {
            logger.error("Unable to decrypt data", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

