/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.json.internal;

import java.io.IOException;
import java.io.Reader;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONArtifact;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;
import org.apache.commons.json.OrderedJSONObject;
import org.apache.commons.json.internal.Token;
import org.apache.commons.json.internal.Tokenizer;

public class Parser {
    private Tokenizer tokenizer;
    private Token lastToken;
    private JSONArtifact jArtifact;
    private boolean firstArtifact = false;

    public Parser(Reader reader) throws JSONException {
        try {
            this.tokenizer = new Tokenizer(reader, false);
        }
        catch (IOException iOException) {
            JSONException jSONException = new JSONException("Error occurred during input read.");
            jSONException.initCause(iOException);
            throw jSONException;
        }
    }

    public Parser(Reader reader, boolean bl) throws JSONException {
        try {
            this.tokenizer = new Tokenizer(reader, bl);
        }
        catch (IOException iOException) {
            JSONException jSONException = new JSONException("Error occurred during input read.");
            jSONException.initCause(iOException);
            throw jSONException;
        }
    }

    public JSONObject parse() throws JSONException {
        return this.parse(false, (JSONObject)null);
    }

    public JSONObject parse(JSONObject jSONObject) throws JSONException {
        return this.parse(false, jSONObject);
    }

    public JSONObject parse(boolean bl) throws JSONException {
        try {
            this.lastToken = this.tokenizer.next();
        }
        catch (IOException iOException) {
            JSONException jSONException = new JSONException("Error occurred during input read.");
            jSONException.initCause(iOException);
            throw jSONException;
        }
        return this.parseObject(bl, null);
    }

    public JSONObject parse(boolean bl, JSONObject jSONObject) throws JSONException {
        try {
            this.lastToken = this.tokenizer.next();
        }
        catch (IOException iOException) {
            JSONException jSONException = new JSONException("Error occurred during input read.");
            jSONException.initCause(iOException);
            throw jSONException;
        }
        return this.parseObject(bl, jSONObject);
    }

    public JSONArray parse(JSONArray jSONArray) throws JSONException {
        return this.parse(false, jSONArray);
    }

    public JSONArray parse(boolean bl, JSONArray jSONArray) throws JSONException {
        try {
            this.lastToken = this.tokenizer.next();
        }
        catch (IOException iOException) {
            JSONException jSONException = new JSONException("Error occurred during input read.");
            jSONException.initCause(iOException);
            throw jSONException;
        }
        return this.parseArray(bl, jSONArray);
    }

    public JSONObject parseObject() throws JSONException {
        return this.parseObject(false, null);
    }

    public JSONObject parseObject(boolean bl, JSONObject jSONObject) throws JSONException {
        try {
            JSONObject jSONObject2;
            block8: {
                jSONObject2 = null;
                jSONObject2 = jSONObject != null ? jSONObject : (!bl ? new JSONObject() : new OrderedJSONObject());
                if (this.lastToken != Token.TokenBraceL) {
                    throw new JSONException("Expecting '{' " + this.tokenizer.onLineCol() + " instead, obtained token: '" + this.lastToken + "'");
                }
                this.lastToken = this.tokenizer.next();
                while (true) {
                    if (this.lastToken == Token.TokenEOF) {
                        throw new JSONException("Unterminated object " + this.tokenizer.onLineCol());
                    }
                    if (this.lastToken == Token.TokenBraceR) break block8;
                    if (!this.lastToken.isString()) {
                        throw new JSONException("Expecting string key " + this.tokenizer.onLineCol());
                    }
                    String string = this.lastToken.getString();
                    this.lastToken = this.tokenizer.next();
                    if (this.lastToken != Token.TokenColon) {
                        throw new JSONException("Expecting colon " + this.tokenizer.onLineCol());
                    }
                    this.lastToken = this.tokenizer.next();
                    Object object = this.parseValue(bl);
                    jSONObject2.put(string, object);
                    if (this.lastToken == Token.TokenComma) {
                        this.lastToken = this.tokenizer.next();
                        continue;
                    }
                    if (this.lastToken != Token.TokenBraceR) break;
                }
                throw new JSONException("expecting either ',' or '}' " + this.tokenizer.onLineCol());
            }
            this.lastToken = this.tokenizer.next();
            return jSONObject2;
        }
        catch (IOException iOException) {
            JSONException jSONException = new JSONException("Error occurred during object input read.");
            jSONException.initCause(iOException);
            throw jSONException;
        }
    }

    public JSONArray parseArray() throws JSONException {
        return this.parseArray(false, null);
    }

    public JSONArray parseArray(boolean bl, JSONArray jSONArray) throws JSONException {
        JSONArray jSONArray2 = null;
        jSONArray2 = jSONArray != null ? jSONArray : new JSONArray();
        try {
            block6: {
                if (this.lastToken != Token.TokenBrackL) {
                    throw new JSONException("Expecting '[' " + this.tokenizer.onLineCol());
                }
                this.lastToken = this.tokenizer.next();
                while (true) {
                    if (this.lastToken == Token.TokenEOF) {
                        throw new JSONException("Unterminated array " + this.tokenizer.onLineCol());
                    }
                    if (this.lastToken == Token.TokenBrackR) break block6;
                    Object object = this.parseValue(bl);
                    jSONArray2.add(object);
                    if (this.lastToken == Token.TokenComma) {
                        this.lastToken = this.tokenizer.next();
                        continue;
                    }
                    if (this.lastToken != Token.TokenBrackR) break;
                }
                throw new JSONException("expecting either ',' or ']' " + this.tokenizer.onLineCol());
            }
            this.lastToken = this.tokenizer.next();
        }
        catch (IOException iOException) {
            JSONException jSONException = new JSONException("Error occurred during array input read.");
            jSONException.initCause(iOException);
            throw jSONException;
        }
        return jSONArray2;
    }

    public Object parseValue() throws JSONException {
        return this.parseValue(false);
    }

    public Object parseValue(boolean bl) throws JSONException {
        if (this.lastToken == Token.TokenEOF) {
            throw new JSONException("Expecting property value " + this.tokenizer.onLineCol());
        }
        try {
            if (this.lastToken.isNumber()) {
                Number number = this.lastToken.getNumber();
                this.lastToken = this.tokenizer.next();
                return number;
            }
            if (this.lastToken.isString()) {
                String string = this.lastToken.getString();
                this.lastToken = this.tokenizer.next();
                return string;
            }
            if (this.lastToken == Token.TokenFalse) {
                this.lastToken = this.tokenizer.next();
                return Boolean.FALSE;
            }
            if (this.lastToken == Token.TokenTrue) {
                this.lastToken = this.tokenizer.next();
                return Boolean.TRUE;
            }
            if (this.lastToken == Token.TokenNull) {
                this.lastToken = this.tokenizer.next();
                return null;
            }
            if (this.lastToken == Token.TokenBrackL) {
                return this.parseArray(bl, null);
            }
            if (this.lastToken == Token.TokenBraceL) {
                return this.parseObject(bl, null);
            }
        }
        catch (IOException iOException) {
            JSONException jSONException = new JSONException("Error occurred during value input read.");
            jSONException.initCause(iOException);
            throw jSONException;
        }
        throw new JSONException("Invalid token " + this.tokenizer.onLineCol());
    }
}

