/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.config.setup;

import com.ibm.bi.config.setup.CogLocaleConfiguration;
import com.ibm.bi.config.setup.CogstartupConfiguration;
import com.ibm.bi.config.setup.ConfigurationSourceFactoryInt;
import com.ibm.bi.config.util.ConfigurationUtils;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.configuration.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationSourceFactory
implements ConfigurationSourceFactoryInt {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationSourceFactory.class);
    private static final String DISPATCHER_PROPERTIES = "configuration/dispatcher.properties";

    @Override
    public CogLocaleConfiguration getCogLocaleConfiguration() throws ConfigurationException {
        return new CogLocaleConfiguration(ConfigurationUtils.resolvePath("configuration/coglocale.xml"));
    }

    @Override
    public CogstartupConfiguration getCogstartupConfiguration() throws ConfigurationException {
        return new CogstartupConfiguration(ConfigurationUtils.resolvePath("configuration/cogstartup.xml"));
    }

    @Override
    public URL getDispatcherPropertiesFilename() {
        try {
            URL url = new File(ConfigurationUtils.resolvePath(DISPATCHER_PROPERTIES)).toURI().toURL();
            log.debug("getDispatcherPropertiesFilename url " + url);
            return url;
        }
        catch (MalformedURLException e) {
            log.error("unexpected error creating dispatcher.properties URL", (Throwable)e);
            return null;
        }
    }

    @Override
    public String getMetadataPath() {
        return ConfigurationUtils.getInstallRoot();
    }
}

