/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.admin.commons.filters;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.lang.StringUtils;

public class AdminRequestWrapper
extends HttpServletRequestWrapper {
    private final Map<String, String[]> modifiableParameters = new TreeMap<String, String[]>();
    private Map<String, String[]> allParameters = null;
    private boolean mPassportParameterAllowed = false;

    public AdminRequestWrapper(HttpServletRequest request, boolean mPassportParameterAllowed, Map<String, String[]> additionalParams) {
        super(request);
        this.modifiableParameters.putAll(additionalParams);
        this.mPassportParameterAllowed = mPassportParameterAllowed;
    }

    public String getParameter(String name) {
        String[] strings = this.getParameterMap().get(name);
        if (strings != null) {
            return strings[0];
        }
        return super.getParameter(name);
    }

    public Map<String, String[]> getParameterMap() {
        if (this.allParameters == null) {
            this.allParameters = new TreeMap<String, String[]>();
            this.allParameters.putAll(super.getParameterMap());
            this.allParameters.putAll(this.modifiableParameters);
        }
        return Collections.unmodifiableMap(this.allParameters);
    }

    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.getParameterMap().keySet());
    }

    public String[] getParameterValues(String name) {
        return this.getParameterMap().get(name);
    }

    public String getQueryString() {
        String qs = super.getQueryString();
        if (StringUtils.isNotBlank((String)qs) && !this.mPassportParameterAllowed) {
            return qs.replaceAll("(\\?|&)?m_passportID=[^&]+(&)?", "$1");
        }
        return qs;
    }
}

