/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.admin.commons.json;

import com.ibm.bi.admin.commons.json.JsonEngine;
import com.ibm.bi.admin.commons.json.JsonEngineFactory;
import com.ibm.bi.admin.commons.utilities.AdminUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.apache.commons.codec.Charsets;

@Provider
public class JsonEngineProvider
implements MessageBodyReader<Object>,
MessageBodyWriter<Object> {
    private JsonEngine jsonEngine = JsonEngineFactory.getDefaultEngine();

    public long getSize(Object arg0, Class<?> arg1, Type arg2, Annotation[] arg3, MediaType arg4) {
        return -1L;
    }

    public boolean isWriteable(Class<?> arg0, Type arg1, Annotation[] arg2, MediaType arg3) {
        return true;
    }

    public void writeTo(Object value, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        String stringValue = value instanceof String ? (String)value : this.jsonEngine.toJson(value);
        entityStream.write(stringValue.getBytes(Charsets.UTF_8));
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return true;
    }

    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        if (type.isAssignableFrom(InputStream.class)) {
            return entityStream;
        }
        byte[] bodyContent = AdminUtil.readFromStream(entityStream);
        String body = AdminUtil.getUtf8StringFromBytes(bodyContent);
        if (type.isAssignableFrom(String.class)) {
            return body;
        }
        return this.jsonEngine.fromJson(body, type);
    }
}

