/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.admin.commons.utilities;

import com.ibm.bi.admin.commons.exception.AdminException;
import com.ibm.bi.admin.commons.utilities.AdminCommonMessageKeys;
import com.ibm.bi.admin.commons.utilities.AdminLogger;
import com.ibm.bi.admin.commons.utilities.AdminLoggerFactory;
import com.ibm.bi.admin.commons.utilities.BiBusUtils;
import com.ibm.bi.json.DefaultJsonFactory;
import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonObject;
import com.ibm.bi.json.JsonParser;
import com.ibm.bi.platform.commons.messages.IMessageKey;
import com.ibm.bi.platform.commons.messages.MessageUtil;
import com.ibm.bi.soap.services.BiBus;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.json.JSONObject;

public class Utils {
    private static final String CONTEXT_ROOT_JNDI_NAME = "contextRoot";
    private static final AdminLogger logger = AdminLoggerFactory.getLogger(Utils.class);

    public static byte[] readFromStream(InputStream stream) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1000];
        int wasRead = 0;
        do {
            if ((wasRead = stream.read(buffer)) <= 0) continue;
            baos.write(buffer, 0, wasRead);
        } while (wasRead > -1);
        return baos.toByteArray();
    }

    public static String getUtf8StringFromBytes(byte[] content) throws UnsupportedEncodingException {
        return new String(content, "UTF-8");
    }

    public static File getConfigParameterAsFile(String configPara, String defaultValue) {
        try {
            InitialContext context = new InitialContext();
            String contextRoot = context.lookup(configPara).toString();
            logger.debug("The path defines in adminSchemaConfig.xml is: " + contextRoot);
            return new File(contextRoot);
        }
        catch (NamingException ex) {
            File currentDir = null;
            currentDir = new File("").getAbsoluteFile();
            File contextRoot = currentDir.getParentFile();
            logger.debug("The default relative path of is: " + contextRoot);
            return new File(contextRoot, defaultValue);
        }
    }

    public static File getContextRoot() {
        return Utils.getConfigParameterAsFile(CONTEXT_ROOT_JNDI_NAME, "");
    }

    public static String[] getCurrentuserTimeZoneAndLocale(HttpServletRequest request) {
        String[] userTimeZoneandLocale = new String[2];
        try {
            BiBus biBus = BiBusUtils.getBiBus(request);
            List retData = biBus.contentManager.query("~", (List)new JsonArray(new Object[]{"timeZoneID", "contentLocale"}), null, null);
            if (retData != null && !retData.isEmpty()) {
                JSONObject accountInfo = new JSONObject(retData.get(0));
                userTimeZoneandLocale[0] = accountInfo.optString("timeZoneID");
                if (userTimeZoneandLocale[0] == null || userTimeZoneandLocale[0].isEmpty()) {
                    userTimeZoneandLocale[0] = TimeZone.getDefault().getID();
                }
                userTimeZoneandLocale[1] = accountInfo.optString("contentLocale");
                if (userTimeZoneandLocale[1] == null || userTimeZoneandLocale[1].isEmpty()) {
                    userTimeZoneandLocale[1] = Locale.getDefault().toString();
                }
            }
        }
        catch (Exception ex) {
            throw new AdminException(ex);
        }
        return userTimeZoneandLocale;
    }

    public static String formatDateFromUTC(String utcDate, String timezoneId, String locale) {
        if (utcDate.length() == 0) {
            return "";
        }
        String dateTimePattern = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
        Locale oLocale = new Locale(locale);
        Date oDate = Utils.parseDateTime(utcDate, dateTimePattern, "GMT");
        SimpleDateFormat outDateFormat = new SimpleDateFormat(dateTimePattern, oLocale);
        outDateFormat.setTimeZone(TimeZone.getTimeZone(timezoneId));
        try {
            return outDateFormat.format(oDate);
        }
        catch (IllegalArgumentException e) {
            throw new AdminException(e);
        }
    }

    private static Date parseDateTime(String sDate, String pattern, String timeZone) {
        SimpleDateFormat informat = new SimpleDateFormat(pattern);
        informat.setTimeZone(TimeZone.getTimeZone(timeZone));
        Date retDate = null;
        try {
            retDate = informat.parse(sDate);
        }
        catch (Exception ex) {
            throw new AdminException(ex);
        }
        return retDate;
    }

    public static String getOwnerDefaultName(HttpServletRequest request, String searchPath) {
        String ownerNameUnavailable = Utils.getOwnerDefaultNameAsUnavailable(request);
        String defaultName = "";
        if (searchPath != null) {
            try {
                BiBus biBus = BiBusUtils.getBiBus(request);
                List retData = biBus.contentManager.query(searchPath, (List)new JsonArray(new Object[]{"defaultName"}), null, null);
                if (retData != null && !retData.isEmpty()) {
                    JSONObject accountInfo = new JSONObject(retData.get(0));
                    defaultName = accountInfo.optString("defaultName");
                    if (defaultName == null || defaultName.isEmpty()) {
                        defaultName = ownerNameUnavailable;
                    }
                } else {
                    defaultName = ownerNameUnavailable;
                }
            }
            catch (Exception ex) {
                throw new AdminException(ex);
            }
        }
        return defaultName;
    }

    public static String getOwnerDefaultNameAsUnavailable(HttpServletRequest request) {
        return MessageUtil.getMessage((Locale)(request != null ? request.getLocale() : null), (IMessageKey.Param0)AdminCommonMessageKeys.UNAVAILABLE);
    }

    public static String getOwnerDefaultNameAsNone(HttpServletRequest request) {
        return MessageUtil.getMessage((Locale)(request != null ? request.getLocale() : null), (IMessageKey.Param0)AdminCommonMessageKeys.NONE);
    }

    public static void setFinalField(Object obj, String fieldName, Object value) throws Exception {
        Field field = obj.getClass().getField(fieldName);
        field.setAccessible(true);
        Field modifiersField = Field.class.getDeclaredField("modifiers");
        modifiersField.setAccessible(true);
        modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
        field.set(obj, value);
    }

    public static Object string2Json(String value) throws Exception {
        return new JsonParser().parse((Reader)new StringReader(value));
    }

    public static Map buildQUeryOptionsWithRefProps(String key, String ... properties) {
        JsonArray propValues = new JsonArray();
        for (String props : properties) {
            propValues.add((Object)props);
        }
        JsonArray refProps = Utils.addRefProp(key, propValues);
        Map options = DefaultJsonFactory.instance.createObject();
        options.put("refProps", refProps);
        return options;
    }

    public static JsonArray addRefProp(String key, JsonArray props) {
        JsonArray refProps = new JsonArray();
        JsonObject newRefProp = new JsonObject();
        newRefProp.put("refPropName", (Object)key);
        newRefProp.put("properties", (Object)props);
        refProps.add((Object)newRefProp);
        return refProps;
    }
}

