/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.soap.services;

import com.ibm.bi.json.JsonFactory;
import com.ibm.bi.soap.schema.Method;
import com.ibm.bi.soap.schema.SoapFaultHandler;
import com.ibm.bi.soap.schema.TypeLibrary;
import com.ibm.bi.soap.services.BiBus;
import com.ibm.bi.soap.services.EmsBaseService;
import com.ibm.bi.soap.services.ServiceLoader;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;

public class EventMgmtService
extends EmsBaseService
implements SoapFaultHandler {
    static Method RUN_SPECIFICATION;
    static Method NEXT_PAGE;
    static Method PREVIOUS_PAGE;
    static Method FIRST_PAGE;
    static Method LAST_PAGE;
    static Method RELEASE;
    static Method RUN_AT;
    static Method CANCEL_EVENT;
    static Method CANCEL_EVENTS;
    static Method HOLD_EVENT;
    static Method HOLD_EVENTS;
    static Method RELEASE_EVENT;
    static Method RELEASE_EVENTS;
    static Method UPDATE_EVENTS;

    static void init(TypeLibrary typeLib) throws XMLStreamException, IOException {
        HashMap<String, Method> methods;
        ServiceLoader serviceLoader = new ServiceLoader();
        try (InputStream is = EventMgmtService.class.getResourceAsStream("eventManagementService.xml");){
            methods = serviceLoader.load(typeLib, is);
        }
        RUN_SPECIFICATION = methods.get("runSpecification");
        NEXT_PAGE = methods.get("nextPage");
        PREVIOUS_PAGE = methods.get("previousPage");
        FIRST_PAGE = methods.get("firstPage");
        LAST_PAGE = methods.get("lastPage");
        RELEASE = methods.get("release");
        RUN_AT = methods.get("runAt");
        CANCEL_EVENT = methods.get("cancelEvent");
        CANCEL_EVENTS = methods.get("cancelEvents");
        HOLD_EVENT = methods.get("holdEvent");
        HOLD_EVENTS = methods.get("holdEvents");
        RELEASE_EVENT = methods.get("releaseEvent");
        RELEASE_EVENTS = methods.get("releaseEvents");
        UPDATE_EVENTS = methods.get("updateEvents");
    }

    public EventMgmtService(BiBus bus) {
        super(bus);
    }

    public Map runSpecification(String specification, Map options) throws Exception {
        JsonFactory json = this.bus.getJsonFactory();
        Map request = json.createObject();
        Map specMap = json.createObject();
        specMap.put(json.createString("value"), json.createString(specification));
        specMap.put(json.createString("type"), json.createString("eventManagementServiceSpecification"));
        request.put(json.createString("specification"), specMap);
        List parameterValues = json.createArray();
        request.put(json.createString("parameterValues"), parameterValues);
        List opts = this.parseOptions(options);
        request.put(json.createString("options"), opts);
        return (Map)this.invoke(RUN_SPECIFICATION, request);
    }

    public Map nextPage(Map primaryRequest, Map options) throws Exception {
        return (Map)this.invoke(NEXT_PAGE, this.createSecondaryRequest(primaryRequest, options));
    }

    public Map previousePage(Map primaryRequest, Map options) throws Exception {
        return (Map)this.invoke(PREVIOUS_PAGE, this.createSecondaryRequest(primaryRequest, options));
    }

    public Map firstPage(Map primaryRequest, Map options) throws Exception {
        return (Map)this.invoke(FIRST_PAGE, this.createSecondaryRequest(primaryRequest, options));
    }

    public Map lastPage(Map primaryRequest, Map options) throws Exception {
        return (Map)this.invoke(LAST_PAGE, this.createSecondaryRequest(primaryRequest, options));
    }

    public void release(Map primaryRequest) throws Exception {
        this.invoke(RELEASE, this.createReleaseRequest(primaryRequest));
    }

    public Map runAt(String searchPath, String at, List options, List parameters) throws Exception {
        JsonFactory json = this.bus.getJsonFactory();
        Map request = json.createObject();
        request.put(json.createString("objectPath"), json.createString(searchPath));
        request.put(json.createString("startTime"), json.createString(at));
        request.put(json.createString("options"), options);
        request.put(json.createString("parameterValues"), parameters);
        Map response = json.createObject();
        response.put("eventID", this.invoke(RUN_AT, request));
        return response;
    }

    public Map cancelEvent(String eventID) throws Exception {
        JsonFactory json = this.bus.getJsonFactory();
        Map request = json.createObject();
        request.put(json.createString("eventID"), json.createString(eventID));
        return (Map)this.invoke(CANCEL_EVENT, request);
    }

    public void holdEvent(String eventID) throws Exception {
        JsonFactory json = this.bus.getJsonFactory();
        Map request = json.createObject();
        request.put(json.createString("eventID"), json.createString(eventID));
        this.invoke(HOLD_EVENT, request);
    }

    public void releaseEvent(String eventID) throws Exception {
        JsonFactory json = this.bus.getJsonFactory();
        Map request = json.createObject();
        request.put(json.createString("eventID"), json.createString(eventID));
        this.invoke(RELEASE_EVENT, request);
    }

    public void cancelEvents(List eventIDs) throws Exception {
        JsonFactory json = this.bus.getJsonFactory();
        Map request = json.createObject();
        request.put(json.createString("eventIDs"), eventIDs);
        this.invoke(CANCEL_EVENTS, request);
    }

    public void holdEvents(List eventIDs) throws Exception {
        JsonFactory json = this.bus.getJsonFactory();
        Map request = json.createObject();
        request.put(json.createString("eventIDs"), eventIDs);
        this.invoke(HOLD_EVENTS, request);
    }

    public void releaseEvents(List eventIDs) throws Exception {
        JsonFactory json = this.bus.getJsonFactory();
        Map request = json.createObject();
        request.put(json.createString("eventIDs"), eventIDs);
        this.invoke(RELEASE_EVENTS, request);
    }

    public void updateEvents(List eventRecords) throws Exception {
        JsonFactory json = this.bus.getJsonFactory();
        Map request = json.createObject();
        request.put(json.createString("events"), eventRecords);
        this.invoke(UPDATE_EVENTS, request);
    }
}

