/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.soap.xml;

import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class XmlStreamUtils {
    private static final XMLInputFactory xmlInputFactory = XmlStreamUtils.createXmlInputFactory();

    private XmlStreamUtils() {
    }

    public static XMLInputFactory getInputFactory() {
        return xmlInputFactory;
    }

    public static void closeReader(XMLStreamReader reader) {
        try {
            reader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static XMLInputFactory createXmlInputFactory() {
        XMLInputFactory result = XMLInputFactory.newFactory();
        result.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        result.setProperty("javax.xml.stream.supportDTD", false);
        return result;
    }

    public static void skipElement(XMLStreamReader reader) throws XMLStreamException {
        int level = 1;
        while (level != 0) {
            switch (reader.next()) {
                case 1: {
                    ++level;
                    break;
                }
                case 2: {
                    --level;
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 12: {
                    break;
                }
                case 8: {
                    throw new XMLStreamException("unexpected end of document");
                }
            }
        }
    }
}

