/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.admin.core.utils;

import com.ibm.bi.admin.core.utils.JsonUtils;
import com.ibm.bi.admin.crypto.utilities.Crypto;
import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonObject;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CredentialHelper {
    public static final String TAG_CREDENTIAL = "credential";
    public static final String TAG_ENCRYPTEDVALUE = "encryptedValue";
    private static final String SECRETKEY = "secretKey";
    private static final String AUTHKEY = "authKey";
    private static final String[] PASSWORDS = new String[]{"password", "cubePassword", "secretKey", "authKey"};
    private static final Logger LOGGER = LoggerFactory.getLogger(CredentialHelper.class);

    public static String encode(Object value) {
        String encoded = JsonUtils.json2Xml(value, TAG_CREDENTIAL);
        String encryptedValue = new Crypto().encryptString(encoded);
        StringBuilder buf = new StringBuilder(encryptedValue.length() + 58);
        buf.append("<credential><encryptedValue>").append(encryptedValue).append("</encryptedValue></credential>");
        return buf.toString();
    }

    public static String convertToXML(Object value) {
        return JsonUtils.json2Xml(value, TAG_CREDENTIAL);
    }

    public static JsonObject decode(String value) {
        return CredentialHelper.decode(value, true);
    }

    public static JsonObject decode(String value, boolean bPatchPassword) {
        JsonObject root = null;
        try {
            root = JsonUtils.xml2Json(value);
            String encryptedValue = root.getObject(TAG_CREDENTIAL).getString(TAG_ENCRYPTEDVALUE);
            String decrypedValue = new Crypto().decryptString(encryptedValue);
            root = JsonUtils.xml2Json(decrypedValue);
        }
        catch (NullPointerException npe) {
            LOGGER.debug(npe.getMessage(), (Throwable)npe);
        }
        catch (XMLStreamException se) {
            throw new RuntimeException(se);
        }
        if (bPatchPassword) {
            CredentialHelper.patchPasswords(root);
        }
        return root;
    }

    private static void patchPasswords(Object o) {
        block7: {
            block6: {
                if (o == null) {
                    return;
                }
                if (!(o instanceof JsonObject)) break block6;
                block0: for (Map.Entry entry : ((JsonObject)o).entrySet()) {
                    String name = (String)entry.getKey();
                    for (String p : PASSWORDS) {
                        if (!p.equals(name)) continue;
                        if (name.equals(SECRETKEY)) {
                            entry.setValue("###SECRETKEY###");
                            continue block0;
                        }
                        if (name.equals(AUTHKEY)) {
                            entry.setValue("###KEY###");
                            continue block0;
                        }
                        entry.setValue("###PASSWORD###");
                        continue block0;
                    }
                    CredentialHelper.patchPasswords(entry.getValue());
                }
                break block7;
            }
            if (!(o instanceof JsonArray)) break block7;
            for (Object item : (JsonArray)o) {
                CredentialHelper.patchPasswords(item);
            }
        }
    }
}

