/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.admin.core.utils;

import com.ibm.bi.admin.core.exceptions.AdminException;
import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.StringTokenizer;

public class FieldsQueryParam {
    private JsonArray properties = null;
    private JsonArray refProps = null;
    private static final String DELIMS_FIELD = ",{}";
    private static final String DELIMS_PROPERTY_REGEX = "\\.";
    private static final String DELIMS_PROPERTY = ".";
    private static final String ERROR_MSG = "Invalid syntax for parameter fields.";

    public FieldsQueryParam(String queryString) throws AdminException {
        this(queryString, null, true);
    }

    public FieldsQueryParam(String queryString, String defaults) throws AdminException {
        this(queryString, defaults, true);
    }

    public FieldsQueryParam(String queryString, String defaults, boolean addImplicitDefaults) throws AdminException {
        if (queryString == null || queryString.isEmpty()) {
            if (defaults == null) {
                defaults = "defaultName";
            }
            queryString = defaults;
        }
        if (addImplicitDefaults) {
            queryString = queryString + ",modificationTime,version,id";
        }
        this.properties = new JsonArray();
        this.parse(queryString);
    }

    public JsonArray getProperties() {
        return this.properties;
    }

    public boolean hasProperty(String prop) {
        if (this.properties == null) {
            return false;
        }
        return this.properties.contains((Object)prop);
    }

    public JsonArray getRefProps() {
        return this.refProps;
    }

    public void addRefProp(String key, JsonArray props) {
        if (this.refProps == null) {
            this.refProps = new JsonArray();
        }
        for (Object refPropObj : this.refProps) {
            JsonObject refProp = (JsonObject)refPropObj;
            if (!refProp.getString("refPropName").equals(key)) continue;
            this.mergeRefProps(props, refProp);
            return;
        }
        JsonObject newRefProp = new JsonObject();
        newRefProp.put("refPropName", (Object)key);
        newRefProp.put("properties", (Object)props);
        this.refProps.add((Object)newRefProp);
    }

    private void mergeRefProps(JsonArray props, JsonObject refProp) {
        JsonArray currProps = refProp.getArray("properties");
        for (Object newProp : props) {
            String newStrProp = (String)newProp;
            if (currProps.contains((Object)newStrProp)) continue;
            currProps.add((Object)newStrProp);
        }
    }

    private void parse(String params) {
        Map<String, JsonArray> paramsMap = this.parseParams(params);
        this.translateMapToCmQueryOptions(paramsMap);
    }

    private void translateMapToCmQueryOptions(Map<String, JsonArray> paramsMap) {
        for (String key : paramsMap.keySet()) {
            this.properties.add((Object)key);
            JsonArray value = paramsMap.get(key);
            if (value.isEmpty()) continue;
            this.addRefProp(key, value);
        }
    }

    private Map<String, JsonArray> parseParams(String params) {
        HashMap<String, JsonArray> paramsMap = new HashMap<String, JsonArray>();
        StringTokenizer st = new StringTokenizer(params, DELIMS_FIELD, true);
        String possibleTokenBeforeOpeningBracket = "";
        int bracketCounter = 0;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.contentEquals(",")) continue;
            if (token.contentEquals("{")) {
                if (bracketCounter > 0) {
                    throw new AdminException(ERROR_MSG);
                }
                ++bracketCounter;
                continue;
            }
            if (token.contentEquals("}")) {
                if (bracketCounter == 0) {
                    throw new AdminException(ERROR_MSG);
                }
                --bracketCounter;
                continue;
            }
            String[] propArray = token.split(DELIMS_PROPERTY_REGEX);
            if (propArray.length == 2) {
                if (bracketCounter > 0 || propArray[0].isEmpty() || propArray[1].isEmpty()) {
                    throw new AdminException(ERROR_MSG);
                }
                if (!paramsMap.containsKey(propArray[0])) {
                    paramsMap.put(propArray[0], new JsonArray());
                }
                ((JsonArray)paramsMap.get(propArray[0])).add((Object)propArray[1]);
                continue;
            }
            if (propArray.length == 1) {
                if (token.contains(DELIMS_PROPERTY)) {
                    throw new AdminException(ERROR_MSG);
                }
                if (bracketCounter > 0) {
                    ((JsonArray)paramsMap.get(possibleTokenBeforeOpeningBracket)).add((Object)propArray[0]);
                    continue;
                }
                possibleTokenBeforeOpeningBracket = token;
                if (paramsMap.containsKey(propArray[0])) continue;
                paramsMap.put(propArray[0], new JsonArray());
                continue;
            }
            throw new AdminException(ERROR_MSG);
        }
        if (bracketCounter > 0) {
            throw new AdminException(ERROR_MSG);
        }
        return paramsMap;
    }

    public int hashCode() {
        return Objects.hash(this.properties, this.refProps);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof FieldsQueryParam)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        FieldsQueryParam fieldsObj = (FieldsQueryParam)obj;
        return (this.properties == null ? fieldsObj.properties == null : this.properties.containsAll((Collection)fieldsObj.properties)) && (this.refProps == null ? fieldsObj.refProps == null : this.refProps.containsAll((Collection)fieldsObj.refProps));
    }
}

