/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.sa.suggestion.api.request;

import com.ibm.bi.predict.data.Context;
import com.ibm.bi.predict.exceptions.BadParametersException;
import com.ibm.bi.predict.sa.suggestion.api.request.AnnotationData;
import com.ibm.bi.predict.sa.suggestion.api.request.AnnotationRequest;
import com.ibm.bi.predict.service.PredictContextFactory;
import com.ibm.bi.predict.types.DataItem;
import com.ibm.bi.predict.types.Slot;
import com.ibm.bi.predict.utils.JsonUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class AnnotationRequestFactory
implements PredictContextFactory {
    static final String VERSION_KEY = "version";
    static final String DATA_KEY = "data";
    static final String USE_KEY = "use";
    static final String ID_KEY = "id";
    static final String DATAITEMS_KEY = "dataItems";

    public Context make(JSONObject parameters) throws JSONException {
        return AnnotationRequestFactory.makeFromJson(parameters);
    }

    public static AnnotationRequest makeFromJson(JSONObject parameters) throws JSONException {
        AnnotationRequest request = new AnnotationRequest();
        String version = JsonUtils.getRequiredString((JSONObject)parameters, (String)VERSION_KEY);
        request.setVersion(version);
        JSONArray jdata = JsonUtils.getRequiredJSONArray((JSONObject)parameters, (String)DATA_KEY);
        request.setData(AnnotationRequestFactory.makeData(jdata));
        JSONArray juse = JsonUtils.getRequiredJSONArray((JSONObject)parameters, (String)USE_KEY);
        request.setUse(AnnotationRequestFactory.makeUse(juse));
        return request;
    }

    static List<AnnotationData> makeData(JSONArray jdata) {
        if (jdata.isEmpty()) {
            throw new BadParametersException("The annotation request must have a 'data' array with at least one entry");
        }
        try {
            ArrayList<AnnotationData> result = new ArrayList<AnnotationData>();
            int size = jdata.size();
            for (int i = 0; i < size; ++i) {
                result.add(AnnotationRequestFactory.makeAnnotationData(jdata.getJSONObject(i)));
            }
            return result;
        }
        catch (JSONException e) {
            throw new BadParametersException(String.format("Bad entry in request 'data': %s", e.getMessage()), (Throwable)e);
        }
    }

    static AnnotationData makeAnnotationData(JSONObject json) throws JSONException {
        String id = json.getString(ID_KEY);
        JSONArray jItems = json.getJSONArray(DATAITEMS_KEY);
        ArrayList<DataItem> dataItems = new ArrayList<DataItem>();
        int size = jItems.size();
        for (int i = 0; i < size; ++i) {
            dataItems.add(DataItem.fromJSON((JSONObject)jItems.getJSONObject(i)));
        }
        return new AnnotationData(id, dataItems);
    }

    static List<Slot> makeUse(JSONArray juse) {
        if (juse.isEmpty()) {
            throw new BadParametersException("The annotation request must have a 'use' array with at least one entry");
        }
        try {
            ArrayList<Slot> result = new ArrayList<Slot>();
            int size = juse.size();
            for (int i = 0; i < size; ++i) {
                result.add(Slot.fromJSON((JSONObject)juse.getJSONObject(i)));
            }
            return result;
        }
        catch (JSONException e) {
            throw new BadParametersException(String.format("Bad entry in request 'data': %s", e.getMessage()), (Throwable)e);
        }
    }
}

