/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.sa.suggestion.domain.parameters;

import com.ibm.bi.predict.sa.execution.annotation.MessageService;
import com.ibm.bi.predict.sa.suggestion.domain.parameters.AnnotationRestriction;
import com.ibm.bi.predict.types.Identifiable;
import java.util.Map;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class AnnotationParameter
implements Identifiable {
    public static final String ID = "id";
    public static final String NAME = "name";
    public static final String DESCRIPTION = "description";
    public static final String DEFAULT = "default";
    public static final String RESTRICTIONS = "restrictions";
    public static final String NAMESUFFIX = "_NAME";
    public static final String DESCRIPTIONSUFFIX = "_DESCRIPTION";
    public static final String OPTION_AUTOMATIC = "OPTION_AUTOMATIC";
    public static final String NUMERIC_VALUE = "NUMERIC_VALUE";
    private final String messageId;
    private final String parameterId;
    private final Object defaultValue;
    private final AnnotationRestriction restrictions;

    public static String nameKey(String messageId) {
        return messageId + NAMESUFFIX;
    }

    public static String descriptionKey(String messageId) {
        return messageId + DESCRIPTIONSUFFIX;
    }

    public AnnotationParameter(String messageId, String parameterId, Object defaultValue, AnnotationRestriction restrictions) {
        this.messageId = messageId;
        this.parameterId = parameterId;
        this.defaultValue = defaultValue;
        this.restrictions = restrictions;
    }

    public String id() {
        return this.messageId;
    }

    public String parameterId() {
        return this.parameterId;
    }

    public JSONObject toJSON(MessageService.MessageBundle messages) throws JSONException {
        JSONObject o = new JSONObject();
        o.put(ID, (Object)this.parameterId);
        o.put(NAME, (Object)messages.getMessage(AnnotationParameter.nameKey(this.messageId), new Object[0]));
        o.put(DESCRIPTION, (Object)messages.getMessage(AnnotationParameter.descriptionKey(this.messageId), new Object[0]));
        if (this.defaultValue instanceof Number) {
            o.put(DEFAULT, (Object)messages.getMessage(NUMERIC_VALUE, new Object[]{this.defaultValue}));
        } else if (OPTION_AUTOMATIC.equals(this.defaultValue)) {
            o.put(DEFAULT, (Object)messages.getMessage(OPTION_AUTOMATIC, new Object[0]));
        } else {
            o.put(DEFAULT, this.defaultValue);
        }
        o.put(RESTRICTIONS, (Map)this.restrictions.toJSON(messages, this.messageId));
        return o;
    }
}

