/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.sa.suggestion.rules.builder;

import com.ibm.bi.predict.sa.suggestion.rules.reader.ExcelTableReader;
import com.ibm.bi.predict.sa.suggestion.rules.reader.RulesGenerator;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;

public class RulesBuilder {
    private static final String INPUT_FILENAME = "sa-rules.xlsx";
    private static final String OUTPUT_LOCATION = "src/main/resources/Rules.java";

    public static void main(String[] args) throws IOException, URISyntaxException {
        System.out.println("Generating Smart Annotations rules...");
        File file = new File(RulesBuilder.resource(INPUT_FILENAME).getFile());
        ExcelTableReader reader = new ExcelTableReader(file);
        File outputFile = new File(OUTPUT_LOCATION);
        try (PrintWriter writer = new PrintWriter(outputFile);){
            RulesGenerator gen = new RulesGenerator(RulesBuilder.wrapper(), reader, writer);
            gen.generate();
        }
        System.out.println("Finished generating Smart Annotations rules. Output: " + outputFile.toString());
    }

    private static String wrapper() throws IOException, URISyntaxException {
        Path wrapperPath = Paths.get(RulesBuilder.resource("sa-rules-class-wrapper.txt").toURI());
        return new String(Files.readAllBytes(wrapperPath));
    }

    private static URL resource(String resourceName) {
        return RulesBuilder.class.getClassLoader().getResource(resourceName);
    }
}

